#!/bin/bash
# Keep this line (these two UNIX lines) unchanged
# Copyright (c) 2010 by Emin Gabrielyan of switzernet.com
# Created and modified on 2010-12-28 by Emin, on 2010-12-29 by Emin
# Version: aa10
                                                                         #
                                                                         #
sync="/home/var/log/radius"                                              #
work="/home/var/log/radius/work"                                         #
                                                                         #
                                                                         #
connect="`cat $work/connect.txt`"                                        #
far_running=/var/log/porta-billing.log                                   #
far_rotated="/var/log/porta-billing.log.?"                               #
rewind=222111000                                                         #
                                                                         #
function samedownload                                                    #
{                                                                        #
  cd $work                                                                 #
  url1="http://parinternet.ch/2/public/101228-radius-log/ver/download.zip" #
  url2="http://switzernet.com/3/public/101228-radius-log/ver/download.zip" #
  url3="http://unappel.ch/2/public/101228-radius-log/ver/download.zip"     #
  url4="http://www.unappel.ch/2/public/101228-radius-log/ver/download.zip" #
  ok=1                                                                     #
  for((i=1;i<=2;i++))                                                      #
  do                                                                       #
    wget -t 1 -N $url1 && break                                              #
    wget -t 1 -N $url2 && break                                              #
    wget -t 1 -N $url3 && break                                              #
    wget -t 1 -N $url4 && break                                              #
    [ $i -eq 2 ] && ok=0                                                     #
  done                                                                     #
  if [ $ok -eq 0 ]                                                         #
  then                                                                     #
    errlog "Cannot download updates"                                         #
    return 0                                                                 #
  fi                                                                       #
  install=0                                                                #
  if [ -f download.zip ]                                                   #
  then                                                                     #
    ls -li --time=ctime --time-style=+%Y-%m-%d,%H:%M:%S download.zip |       #
    cat > download2.txt                                                      #
    if [ -f download1.txt ]                                                  #
    then diff download1.txt download2.txt > /dev/null || install=1           #
    else install=1                                                           #
    fi                                                                       #
    mv download2.txt download1.txt                                           #
  fi                                                                       #
  if [ $install -eq 1 ]                                                    #
  then                                                                     #
    standard "New update received"                                           #
    rm -r Downloads 2>/dev/null                                              #
    unzip -o download.zip -d Downloads |                                     #
    while read s                                                             #
    do standard "$s"                                                         #
    done                                                                     #
  else standard "No update received"                                         #
  fi                                                                       #
  return $install                                                          #
}                                                                        #
                                                                         #
                                                                         #
                                                                         #
                                                                         #
function standard                                                        #
{                                                                        #
  msg=$1                                                                   #
  date +%Y-%m-%d,%H:%M:%S,"$msg" | tee -a $sync/standard.log               #
}                                                                        #
                                                                         #
function errlog                                                          #
{                                                                        #
  msg=$1                                                                   #
  date +%Y-%m-%d,%H:%M:%S,"$msg" | tee -a $sync/error.log                  #
}                                                                        #
                                                                         #
function error                                                           #
{                                                                        #
  errlog $1                                                                #
  unlock                                                                   #
  exit 1                                                                   #
}                                                                        #
                                                                         #
                                                                         #
function createifnone                                                    #
{                                                                        #
  cd $sync                                                                 #
  if [ ! -f ??????,??????,*,*,running,radius.log ]                         #
  then                                                                     #
    exe="f=$far_running; ls -i \$f; wc -c \$f"                               #
    info=`$connect "$exe" 2> /dev/null | awk '{printf ",%s",$1}'`            #
    if [ -z "$info" ]                                                        #
    then error "Error getting remote info"                                   #
    fi                                                                       #
    inode=`echo $info | cut -d, -f2`                                         #
    size=`echo $info | cut -d, -f3`                                          #
    if [ $size -gt $rewind ]                                                 #
    then size=$((size-rewind))                                               #
    else size=0                                                              #
    fi                                                                       #
    cp /dev/null `date +%y%m%d,%H%M%S,$inode,$size,running,radius.log`       #
  fi                                                                       #
}                                                                        #
                                                                         #
                                                                         #
function logsync                                                         #
{                                                                        #
  cd $sync                                                                 #
  local=??????,??????,*,*,running,radius.log                               #
  fdate=`echo $local | cut -d, -f1`                                        #
  ftime=`echo $local | cut -d, -f2`                                        #
  inode=`echo $local | cut -d, -f3`                                        #
  head=`echo $local | cut -d, -f4`                                         #
  set 1 `wc -c $local`                                                     #
  size=$2                                                                  #
  skip=$((head+size))                                                      #
  exe1="set 1 \`ls -i $far_running $far_rotated | egrep ^$inode\\ \`;"     #
  exe2=" f=\$3; [ ! -z \"\$f\" ] &&"                                       #
  exe3=" echo \$f >&2 && dd bs=1 skip=$skip if=\$f"                        #
  far_file=`$connect "$exe1$exe2$exe3" 2>&1 >> $local`                     # Order is important
  if [ -z "$far_file" ]                                                    #
  then error "Error finding the far inode"                                 #
  fi                                                                       #
  echo "$far_file" | while read s                                          #
  do standard "$s"                                                         #
  done                                                                     #
  if [ ! $far_running = `echo "$far_file" | head -1` ]                     #
  then mv $local $fdate,$ftime,$inode,$head,rotated,radius.log             #
  fi                                                                       #
}                                                                        #
                                                                         #
                                                                         #
                                                                         #
function checkfolder                                                     #
{                                                                        #
  cd $sync                                                                 #
  n=`ls ??????,??????,*,*,running,radius.log 2>/dev/null | wc -l`          #
  if [ $n -gt 1 ]                                                          #
  then error "Error with running files"                                    #
  fi                                                                       #
}                                                                        #
                                                                         #
                                                                         #
function lock                                                            #
{                                                                        #
  ls $sync/status=*,lock.log > /dev/null 2>&1 ||                           #
  cp /dev/null $sync/status=free,lock.log                                  #
  if mv $sync/status=free,lock.log $sync/status=busy,lock.log 2>/dev/null  #
  then                                                                     #
    date +%Y-%m-%d,%H:%M:%S,"locked by $$" |                                 #
    tee -a $sync/status=busy,lock.log                                        #
    return 0                                                                 #
  else                                                                     #
    errlog "Since `tail -1 $sync/status=busy,lock.log`"                      #
    return 1                                                                 #
  fi                                                                       #
}                                                                        #
                                                                         #
function unlock                                                          #
{                                                                        #
  if mv $sync/status=busy,lock.log $sync/status=free,lock.log              #
  then                                                                     #
    date +%Y-%m-%d,%H:%M:%S,"unlocked by $$" |                               #
    tee -a $sync/status=free,lock.log                                        #
    return 0                                                                 #
  fi                                                                       #
}                                                                        #
                                                                         #
                                                                         #
function runlock                                                         #
{                                                                        #
  if lock                                                                  #
  then                                                                     #
    for((i=1;i<=7;i++))                                                      #
    do                                                                       #
      checkfolder                                                              #
      createifnone                                                             #
      logsync                                                                  #
      sleep 10                                                                 #
    done                                                                     #
    return 0                                                                 #
  else return 1                                                            #
  fi                                                                       #
}                                                                        #
                                                                         #
                                                                         #
                                                                         #
if runlock                                                               #
then                                                                     #
  if samedownload                                                          #
  then                                                                     #
    unlock                                                                   #
    exit                                                                     #
  else                                                                     #
    unlock                                                                   #
    cd $work                                                                 #
    standard "Quit and self update"                                          #
    exec cp Downloads/run.sh .                                               # Delete process memory
  fi                                                                       #
fi                                                                       #
                                                                         #
                                                                         #
                                                                         #
                                                                         #