# db3001.pp

# module astrad
# v 004
#
# Can be used as an upgrade from v 003
#
# Created on 110311 by yannick.vaucher@switzernet.com
#

import "mysql-server.pp"
import "postfix.pp"
import "perl.pp"

class db3001{

	$module_name = "db3001"
	include mysql-server
	include postfix	
        include perl

	package{[libdbi-perl, libdbd-mysql-perl, ntp, ngrep]:
		ensure      => installed,
                require     => Package["mysql-server"],
	}

        define packagesCPAN {
                perl::installCPAN {    ["YAML",
                                        "Config::IniFiles",
                                        "List::Util",
                                        "Sys::Syslog",
                                        "MIME::Lite",
                                        "Date::Manip"]:
                }
        }

        packagesCPAN{"mysql":
                require     => Package["mysql-server"]
        }


        file { "/etc/db3":
                ensure      => directory,
        }

       file{"/etc/db3/setup-mysql-replication.pl":
                ensure      => file,
                owner       => root,
                group       => root,
                mode        => 755,
                recurse     => true,
                replace     => true,
                source      => "puppet:///$module_name/setup-mysql-replication.pl",
                require     => File["/etc/db3"]
        }


        file{"/etc/db3/110408-db3.sql":
                ensure      => file,
                owner       => root,
                group       => root,
                mode        => 644,
                replace     => true,
                content     => template("$module_name/110408-db3.sql.erb"),
                require     => File["/etc/db3"]
        }

        file{"/etc/db3/setup-mysql-replication.conf":
                ensure      => file,
                owner       => root,
                group       => root,
                mode        => 644,
                replace     => true,
                content     => template("$module_name/setup-mysql-replication.conf.erb"),
                require     => File["/etc/db3"]
        }

        exec { "setup mysql replication":
                command     => "/etc/db3/setup-mysql-replication.pl > /dev/null 2>&1",
                subscribe   => Package["mysql-server"],
                refreshonly => true,
                require     => [ File["/etc/db3/setup-mysql-replication.conf"], File["/etc/db3/110408-db3.sql"], PackagesCPAN["mysql"] , File["/etc/db3/setup-mysql-replication.pl"] ]
        }

}

