class db3001::mysql-server {

        exec { "aptitude update":
                command     => "aptitude update",
        }

        package {  "mysql-server":
                ensure      => installed,
                require     => Exec['aptitude update'],
                notify      => Exec["Set MySQL root password"]
        }

        service { "mysql":
                ensure  => running,
                enable  => true,
                name    => "mysql",
                require => Package["mysql-server"]
        }


        exec { "Set MySQL root password":
                subscribe   => Package["mysql-server"],
                refreshonly => true,
                unless      => "mysqladmin -uroot -p$mysql_root_pass status",
                path        => "/bin:/usr/bin",
                command     => "mysqladmin -uroot password $mysql_root_pass",
                require     => Service["mysql"],
                notify      => Exec["setup mysql replication"]
        }
}
