# /etc/puppet/manifests/classes/perl.pp 

class db3001::perl {
	
	package { perl: ensure => present }

	define installCPAN () {

		
		exec { "CPAN Load ${name}":
			command => "perl -I.cpan -MCPAN -e '\$ENV{PERL_MM_USE_DEFAULT}=1; install +$name'",
			unless  => "perl -M$name -e 1",
			timeout => 600,
			require => Exec['initCPAN'],
		}
	}


	exec { "initCPAN":
		command =>  "wget -O - http://cpanmin.us | perl - --self-upgrade",
		creates  => "/bin/cpanm",
		require => Package['perl'],
	}
}

