class db3001::postfix {
	package { [postfix, mailutils]:
		ensure => installed,
                require => Exec['aptitude update']
	}
		
        file{"/etc/postfix/main.cf":
                ensure  => file,
                owner   => root,
                group   => root,
                mode    => 644,
                replace => true,
                content => template("$module_name/main.cf.erb"),
                require => [Package['postfix'], Package['mailutils']],
                notify  => Exec['postfix restart']
        }

        exec { "postfix restart":
                command     => "/etc/init.d/postfix restart",
                refreshonly => true,
                notify=> Exec['mailalias']
        }

        exec { "mailalias":
                command => "hostname >  /etc/mailname",
                refreshonly => true
        }

}
