#include "ampl.h"

void ampl_prlinks(FILE *f)
{
	int i;
	fprintf(f,"set LINKS :=");
	for(i=0;i<linknu;i++)
	{
		if(!(i%20))	fprintf(f,"\n  ");
		fprintf(f," %3d",i);
	}
	fprintf(f,"\n;\n\n");
}

void ampl_prtransfers(FILE *f, Traffic X)
{
	Traffic x;
	int i;
	fprintf(f,"set TRANSFERS :=");
	for(i=0,x=X;x!=NULL;x=x->next,i++)
	{
		if(!(i%10))	fprintf(f,"\n  ");
		fprintf(f," t%-4d",i);
	}
	fprintf(f,"\n;\n\n");
}

void ampl_prusage(FILE *f, Traffic X)
{
	int i;
	int j;
	Traffic x;
	Transfer a;
	fprintf(f,"param usage (tr):");
	for(j=0;j<linknu;j++)
	{
		if(!(j%20))	fprintf(f,"\n      ");
		fprintf(f," %3d",j);
	}
	fprintf(f," :=");

	for(i=0,x=X;x!=NULL;x=x->next,i++)
	{
		fprintf(f,"\n t%-4d",i);
		a=x->t;
		for(j=0;j<linknu;j++)
		{
			if(!(j%20))	fprintf(f,"\n      ");
			if((a[j/longsz]>>(j%longsz))&1)
				fprintf(f," %3d",1);
			else
				fprintf(f," %3d",0);
		}
	}
	fprintf(f,"\n;\n\n");
}

void ampl_prslots(FILE *f, Traffic X)
{
	int i;
	int duration;
	duration=trafficduration(X);
	fprintf(f,"set SLOTS :=");
	for(i=0;i<duration;i++)
	{
		if(!(i%10))	fprintf(f,"\n  ");
		fprintf(f," i%-3d",i);
	}
	fprintf(f,"\n;\n\n");
}

void ampl_data(char *fname, Traffic X)
{
	FILE *f;
	f=fopen(fname,"w");
	if(f==(FILE*)NULL)
	{
		printf("error opening file %s\n",fname);
		exit(0);
	}
	ampl_prlinks(f);
	ampl_prtransfers(f,X);
	ampl_prslots(f,X);
	ampl_prusage(f,X);
	fclose(f);
}

//=====tests=====

void ampltest1()
{
	int nallocs;
	int i;
	Traffic X;
	char fname[256];

	nallocs=t1nodeallocsnu();
	for(i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);

		sprintf(fname,"topologies\\swisstx%03d-dat.txt",i);
		ampl_data(fname,X);

		while(X) trafficdestr(&X);
		//getchar();
	}


}

