#include "category.h"
#include <stdio.h>
#include <string.h>

void blankfissionsz(Category *R, int* N)
{
	Category Rpos;

	(*N)++;
	if(singular(R))
	{
		categorydestr(R);
		return;
	}
	if(blank(R))
	{
		categorydestr(R);
		return;
	}

	Rpos=fission(R);
	blankfissionsz(&Rpos,N);
	blankfissionsz(R,N);
	return;
}

void deadfissionsz(Category *R, int* N)
{
	Category Rpos;

	(*N)++;
	if(singular(R))
	{
		categorydestr(R);
		return;
	}
	if(dead(R))
	{
		categorydestr(R);
		return;
	}

	Rpos=fission(R);
	deadfissionsz(&Rpos,N);
	deadfissionsz(R,N);
	return;
}

void coveragesz(Category *R, int* i)
{
	Category Rpos;

	if(singular(R))
	{
		(*i)++;
		categorydestr(R);
		return;
	}
	if(blank(R))
	{
		categorydestr(R);
		return;
	}

	Rpos=fission(R);
	coveragesz(&Rpos,i);
	coveragesz(R,i);
	return;
}

Category categoryconst()
{
	Category R;
	R.excluder=NULL;
	R.depot=NULL;
	R.includer=NULL;
	return R;
}

void categorydestr(Category *R)
{
	while(R->excluder) trafficcut(&R->excluder);
	while(R->depot) trafficcut(&R->depot);
	while(R->includer) trafficcut(&R->includer);
}

Category primcategory(Traffic X)
{
	Category R;
	R.excluder=NULL;
	R.depot=trafficdup(X);
	R.includer=NULL;
	return R;
}

Category fission(Category *R)
{
	Category Rpos={NULL,NULL,NULL};
	Transfer x;

	if(R->depot==NULL)
		return Rpos;

	x=R->depot->t;

	Rpos.excluder=noncongestings_wtransfer(R->excluder,x);
	Rpos.depot=noncongestings_wtransfer(R->depot,x);
	Rpos.includer=trafficdup(R->includer);
	trafficadd(&(Rpos.includer),x);

	trafficcut(&(R->depot));
	trafficadd(&(R->excluder),x);
	return Rpos;
}

int singular(Category *R)
{
	if(R->depot==NULL && R->excluder==NULL)
		return 1;
	else
		return 0;
}

int dead(Category *R)
{
	if(R->depot==NULL && R->excluder!=NULL)
		return 1;
	else
		return 0;
}

int blank(Category *R)
{
	Traffic a;

	for(a=R->excluder;a;a=a->next)
	{
		if(trafficcongest_wtransfer(R->depot,a->t))
			continue;
		else
			return 1;
	}
	return 0;
}

void categoryprint(char *s, Category R)
{
	char tmp[8192];
	strcpy(s,"( ");
	trafficprint(tmp,R.excluder);
	strcat(s,tmp);
	strcat(s,", ");
	trafficprint(tmp,R.depot);
	strcat(s,tmp);
	strcat(s,", ");
	trafficprint(tmp,R.includer);
	strcat(s,tmp);
	strcat(s," )");
	return;
}

//=========tests=========

void categorytest1()
{
	Traffic X=NULL;
	Category R;
	char s[10000];

	trafficcreat(&X);
	transferadd(X->t,1);
	trafficcreat(&X);
	transferadd(X->t,2);
	transferadd(X->t,3);
	trafficcreat(&X);
	transferadd(X->t,4);
	trafficcreat(&X);
	transferadd(X->t,5);

	R=primcategory(X);
	categoryprint(s,R);
	printf("R=%s\n",s);
	categorydestr(&R);
	categoryprint(s,R);
	printf("after destruction R=%s\n",s);

	while(X) trafficdestr(&X);
}

void categorytest2()
{
	printf("sizeof Category: %d\n",sizeof(Category));
}

void categorytest3()
{
	Traffic X=NULL;
	Category R;
	Category Rpos;
	char s[10000];

	trafficcreat(&X);
	transferadd(X->t,1);
	transferadd(X->t,4);
	trafficcreat(&X);
	transferadd(X->t,2);
	transferadd(X->t,3);
	trafficcreat(&X);
	transferadd(X->t,4);
	trafficcreat(&X);
	transferadd(X->t,5);

	R=primcategory(X);
	categoryprint(s,R);
	printf("Rprim=%s\n",s);

	Rpos=fission(&R);

	categoryprint(s,Rpos);
	printf("Rpos=%s\n",s);
	categoryprint(s,R);
	printf("Rneg=%s\n",s);

	categorydestr(&Rpos);
	categoryprint(s,Rpos);
	printf("\ndestructed Rpos=%s\n",s);
	categorydestr(&R);
	categoryprint(s,R);
	printf("destructed Rneg=%s\n",s);

	while(X) trafficdestr(&X);
}

void categorytest4()
{
	Category R;
	char s[10000];
	Traffic X;
	Traffic Y;

	X=trafficconst();
	Y=trafficconst();
	trafficcreat(&X);
	transferadd(X->t,1);
	transferadd(X->t,2);
	transferadd(X->t,3);
	trafficcreat(&X);
	transferadd(X->t,4);
	transferadd(X->t,5);
	transferadd(X->t,6);
	trafficcreat(&Y);
	transferadd(Y->t,1);
	transferadd(Y->t,4);
	trafficcreat(&Y);
	transferadd(Y->t,30);
	transferadd(Y->t,20);

	R=categoryconst();
	R.excluder=trafficdup(X);
	R.depot=trafficdup(Y);
	categoryprint(s,R);
	printf("Category %s is%sblank.\n",s,blank(&R)?" ":" not ");

	categorydestr(&R);
	categoryprint(s,R);
	printf("Category after destruction: %s\n",s);

	while(X) trafficdestr(&X);
	while(Y) trafficdestr(&Y);
}


void categorytest5a(Category *R)
{
	static int i=1;
	Category Rpos;

	char s[5000];
	if(singular(R))
	{
		trafficprint(s,R->includer);
		printf("Simultaneity%d=%s\n",i++,s);
		categorydestr(R);
		return;
	}
	if(blank(R))
	{
		categorydestr(R);
		return;
	}

	Rpos=fission(R);
	categorytest5a(&Rpos);
	categorytest5a(R);
}

void categorytest5()
{
	Traffic X=NULL;
	Category R;
	char s[5000];

	trafficcreat(&X);
	transferadd(X->t,1);
	transferadd(X->t,4);
	transferadd(X->t,6);
	trafficcreat(&X);
	transferadd(X->t,2);
	transferadd(X->t,4);
	transferadd(X->t,7);
	trafficcreat(&X);
	transferadd(X->t,3);
	transferadd(X->t,5);

	R=primcategory(X);
	categoryprint(s,R);
	printf("R=%s\n",s);
	categorytest5a(&R);
	categoryprint(s,R);
	printf("after recursion R=%s\n",s);

	while(X) trafficdestr(&X);
}

void categorytest6()
{
	Traffic X;
	Category R;

	X=traffictest7();

	R=primcategory(X);
	categorytest5a(&R);

	while(X) trafficdestr(&X);
}

void categorytest7()
{
	Traffic X;
	Category R;
	int nblank;
	int ndead;
	int nsimult;

	X=traffictest7();

	R=primcategory(X);
	nblank=categorytest7a(&R);
	R=primcategory(X);
	ndead=categorytest7b(&R);
	R=primcategory(X);
	nsimult=categorytest7c(&R);

	while(X) trafficdestr(&X);

	printf("nsimult=%d, nblank=%d, ndead=%d\n",nsimult,nblank,ndead);
	printf("Complexities of blank: %.2f, dead: %.2f\n",(double)nblank/nsimult,(double)ndead*1.0/nsimult);
}

int categorytest7a(Category *R)
{
	static int N=0;
	Category Rpos;

	N++;
	if(singular(R))
	{
		categorydestr(R);
		return N;
	}
	if(blank(R))
	{
		categorydestr(R);
		return N;
	}

	Rpos=fission(R);
	categorytest7a(&Rpos);
	categorytest7a(R);
	return N;
}

int categorytest7b(Category *R)
{
	static int N=0;
	Category Rpos;

	N++;
	if(singular(R))
	{
		categorydestr(R);
		return N;
	}
	if(dead(R))
	{
		categorydestr(R);
		return N;
	}

	Rpos=fission(R);
	categorytest7b(&Rpos);
	categorytest7b(R);
	return N;
}

int categorytest7c(Category *R)
{
	static int i=0;
	Category Rpos;

	if(singular(R))
	{
		i++;
		categorydestr(R);
		return i;
	}
	if(blank(R))
	{
		categorydestr(R);
		return i;
	}

	Rpos=fission(R);
	categorytest7c(&Rpos);
	categorytest7c(R);
	return i;
}

void categorytest8()
{
	Traffic X;
	Category R;
	int nblank;
	int ndead;
	int nsimult;
	char s[5000];

	X=traffictest7();
	trafficprint(s,X);
	printf("X=%s\n",s);

	R=primcategory(X);
	nblank=0;
	blankfissionsz(&R,&nblank);
	R=primcategory(X);
	ndead=0;
	deadfissionsz(&R,&ndead);
	R=primcategory(X);
	nsimult=0;
	coveragesz(&R,&nsimult);

	while(X) trafficdestr(&X);

	printf("nsimult=%d, nblank=%d, ndead=%d\n",nsimult,nblank,ndead);
}
