#include "graph.h"
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include <sys/timeb.h>


Graph graphconst()
{
	Graph G;
	G=NULL;
	return G;
}


Graph graphoftraffic(Traffic X)
{
	Graph Y;
	Traffic a;
	
	Y=graphconst();
	for(a=X;a;a=a->next)
	{
		graphadd(&Y,a->t);
	}
	graphcolorsreset(Y);
	graphverticesdegrees(Y);
	graphverticesneighborhoods(Y);
	return Y;
}

void graphadd(Graph *G, Transfer x)
{
	Graph G1;
	G1=*G;

	*G=(Graph)malloc(sizeof(struct Graph));
	if((*G)==NULL)
	{
		printf("graphadd: memory allocation problem\n");
	}
	(*G)->t=x;
	(*G)->color=0;
	(*G)->degree=0;
	(*G)->neighborhoodsz=0;
	(*G)->neighbors=neighborhoodconst();
	(*G)->next=G1;
}

void graphcut(Graph *G)
{
	Graph G1;
	if((*G)!=NULL)
	{
		G1=*G;
		*G=(*G)->next;
		while(G1->neighbors) neighborhoodcut(&(G1->neighbors));
		free(G1);
	}
}

void graphprint(char *s, Graph G)
{
	char tmp1[1024];
	char tmp2[1024];
	char tmp3[1024];
	Graph a;
	int first=1;

	strcpy(s,"{");
	for(a=G;a!=NULL;a=a->next)
	{
		if(!first)
			strcat(s,", ");
		transferprint(tmp1,a->t);
		neighborhoodprint(tmp2,a->neighbors);
		sprintf(tmp3,"(%s,%s,%d,%d,%d)",tmp1,tmp2,a->color,a->degree,a->neighborhoodsz);
		strcat(s,tmp3);
		first=0;
	}
	strcat(s,"}");
}

void graphtransferscolorsprint(char *s, Graph G)
{
	char tmp1[1024];
	char tmp2[1024];
	Graph a;
	int first=1;

	strcpy(s,"{");
	for(a=G;a!=NULL;a=a->next)
	{
		if(!first)
			strcat(s,", ");
		transferprint(tmp1,a->t);
		sprintf(tmp2,"(%s,%d)",tmp1,a->color);
		strcat(s,tmp2);
		first=0;
	}
	strcat(s,"}");
}

void graphcolorsprint(char *s, Graph G)
{
	char tmp[64];
	Graph a;
	int first=1;

	strcpy(s,"(");
	for(a=G;a!=NULL;a=a->next)
	{
		if(!first)
			strcat(s,", ");
		sprintf(tmp,"(%d,%d,%d)",a->color,a->degree,a->neighborhoodsz);
		strcat(s,tmp);
		first=0;
	}
	strcat(s,")");
}

int graphchromaticity(Graph G)
{
	Graph a;
	int chromaticity=0;

	for(a=G;a;a=a->next)
	{
		if(a->color>chromaticity)
			chromaticity=a->color;
	}
	return chromaticity;
}

int graphnocolorhole(Graph G)
{
	int chromaticity;
	int color;
	Graph a;

	chromaticity=graphchromaticity(G);
	for(color=1;color<=chromaticity;color++)
	{
		for(a=G;a;a=a->next)
		{
			if(a->color==color)
				break;
		}
		if(a==NULL)
			return 0;
	}
	return 1;
}

int graphstartcolor(Graph G)
{
	Graph a;
	int startcolor;
	startcolor=G->color;

	for(a=G;a;a=a->next)
	{
		if(a->color<startcolor)
			startcolor=a->color;
	}
	return startcolor;
}

int graphcolored(Graph G)
{
	if( (graphstartcolor(G)==1) && graphnocolorhole(G) )
		return 1;
	else
		return 0;
}

void graphcolorsreset(Graph G)
{
	Graph a;
	for(a=G;a;a=a->next)
	{
		a->color=0;
	}
}

void graphverticesdegrees(Graph G)
{
	Graph a;
	Graph b;

	for(a=G;a;a=a->next)
	{
		a->degree=0;
		for(b=G;b;b=b->next)
		{
			if(a==b)
				continue;
			if(transferscongest(a->t,b->t))
				(a->degree)++;
		}
	}
}

Neighborhood neighborhoodconst()
{
	Neighborhood a;
	a=NULL;
	return a;
}

void neighborhoodadd(Neighborhood *neighbors, int color)
{
	Neighborhood a;

	if(color<1)
		return;
	for(a=(*neighbors);a;a=a->next)
		if(color==a->color)
			return;

	a=(*neighbors);
	(*neighbors)=(Neighborhood)malloc(sizeof(struct Neighborhood));
	(*neighbors)->color=color;
	(*neighbors)->next=a;
}

void neighborhoodcut(Neighborhood *neighbors)
{
	Neighborhood a;

	if( (*neighbors)!=NULL )
	{
		a=(*neighbors)->next;
		free(*neighbors);
		(*neighbors)=a;
	}
}

int neighborhoodsize(Neighborhood neighbors)
{
	Neighborhood a;
	int i;

	for(a=neighbors,i=0;a;a=a->next,i++)
		continue;
	return i;
}

int neighborhoodfirstfree(Neighborhood neighbors)
{
	Neighborhood a;
	int color;

	for(color=1;;color++)
	{
		for(a=neighbors;a;a=a->next)
		{
			if(a->color==color)
				break;
		}
		if(a==NULL)
			break;
	}
	return color;
}

void neighborhoodprint(char *s, Neighborhood neighbors)
{
	Neighborhood a;
	char tmp[64];
	int first;

	strcpy(s,"{");
	for(a=neighbors,first=1;a;a=a->next,first=0)
	{
		if(!first) strcat(s,",");
		sprintf(tmp,"%d",a->color);
		strcat(s,tmp);
	}
	strcat(s,"}");
}

void graphverticesneighborhoods(Graph G)
{
	Graph a;
	Graph b;
	Neighborhood neighbors;

	for(a=G;a;a=a->next)
	{
		if(a->color>0)
		{
			while(a->neighbors) neighborhoodcut(&(a->neighbors));
			a->neighborhoodsz=0;
			continue;
		}
		neighbors=neighborhoodconst();
		for(b=G;b;b=b->next)
		{
			if(a==b)
				continue;
			if(transferscongest(a->t,b->t))
			{
				neighborhoodadd(&neighbors,b->color);
			}
		}
		a->neighborhoodsz=neighborhoodsize(neighbors);
		while(a->neighbors) neighborhoodcut(&(a->neighbors));
		a->neighbors=neighbors;
	}
}

Graph graphmostwantedvertex(Graph G)
{
	Graph a;
	Graph wanted;
	int first;

	wanted=graphconst();
	for(a=G,first=1;a;a=a->next)
	{
		if(a->color>0)
			continue;
		if
		(
			first
		||
			(a->neighborhoodsz>wanted->neighborhoodsz)
		||
			(
				(a->neighborhoodsz==wanted->neighborhoodsz)
			&&
				(a->degree>wanted->degree)
			)
		)
		{
			wanted=a;
			first=0;
		}
	}
	return wanted;
}

void graphcolor(Graph G)
{
	Graph vertex;

	do
	{
		graphverticesneighborhoods(G);
		vertex=graphmostwantedvertex(G);
		if(vertex)
		{
			if(vertex->color!=0)
			{
				printf("graphcolor: error, the vertex already have a color.\n");
			}
			vertex->color=neighborhoodfirstfree(vertex->neighbors);
		}
	}
	while(vertex);
	if(!graphcolored(G))
	{
		printf("graphcolor: error, the graph is not colored properly.\n");
	}
}

int graphcoloredok(Graph G)
{
	Graph a;
	Graph b;

	if(!graphcolored(G))
	{
		printf("graphcoloredok: error, graph is not colored.\n");
		return 0;
	}
	for(a=G;a;a=a->next)
		for(b=G;b;b=b->next)
			if(a!=b)
				if(transferscongest(a->t,b->t))
					if(a->color==b->color)
					{
						printf("graphcoloredok: error, congesting vertices have identical colors.\n");
						return 0;
					}
	return 1;
}

//=======tests========

void graphtest1()
{
	Traffic X;
	Graph G;
	char xview[1000];
	char gview[1000];

	X=traffictest7();
	G=graphoftraffic(X);

	trafficprint(xview,X);
	graphprint(gview,G);
	printf("X=%s\n",xview);
	printf("G=%s\n",gview);

	while(G) graphcut(&G);
	while(X) trafficdestr(&X);
}

void graphtest2()
{
	Traffic X;
	Graph G;
	char xview[1000];
	char gview[1000];

	X=traffictest7();
	G=graphoftraffic(X);

	trafficprint(xview,X);
	graphcolorsprint(gview,G);
	printf("X=%s\n",xview);
	printf("G=%s\n",gview);

	while(G) graphcut(&G);
	while(X) trafficdestr(&X);
}

void graphtest3()
{
	Traffic X;
	Graph G;
	Graph a;
	int i;
	char gview[1000];

	X=traffictest7();
	G=graphoftraffic(X);

	for(a=G,i=1;a;a=a->next,i++)
	{
		a->color=i;
	}
	graphcolorsprint(gview,G);
	printf("G=%s\n",gview);
	printf("Chromaticity=%d\n",graphchromaticity(G));
	printf("There are%scolor holes.\n",graphnocolorhole(G)?" no ":" ");

	while(G) graphcut(&G);
	while(X) trafficdestr(&X);
}

void graphtest4()
{
	Traffic X;
	Graph G;
	Graph a;
	int i;
	char gview[1000];

	X=traffictest7();
	G=graphoftraffic(X);

	for(a=G,i=1;a;a=a->next,i++)
	{
		a->color=i;
	}
	graphcolorsprint(gview,G);
	printf("G=%s\n",gview);
	printf("Chromaticity=%d\n",graphchromaticity(G));
	printf("There are%scolor holes.\n",graphnocolorhole(G)?" no ":" ");
	printf("Graph is %s colored.\n",graphcolored(G)?"well":"not");

	while(G) graphcut(&G);
	while(X) trafficdestr(&X);
}

void graphtest5()
{
	Neighborhood a;
	char aview[1000];

	a=neighborhoodconst();
	neighborhoodadd(&a,1);
	neighborhoodadd(&a,1);
	neighborhoodadd(&a,2);
	neighborhoodadd(&a,5);
	neighborhoodadd(&a,5);
	neighborhoodadd(&a,3);
	neighborhoodadd(&a,0);
	neighborhoodadd(&a,-1);
	neighborhoodadd(&a,10);
	neighborhoodprint(aview,a);
	printf("a=%s\n",aview);
}

void graphtest6()
{
	Neighborhood a;
	char aview[1000];

	a=neighborhoodconst();
	neighborhoodadd(&a,1);
	neighborhoodadd(&a,1);
	neighborhoodadd(&a,2);
	neighborhoodadd(&a,5);
	neighborhoodadd(&a,5);
	neighborhoodadd(&a,3);
	neighborhoodadd(&a,0);
	neighborhoodadd(&a,-1);
	neighborhoodadd(&a,10);

	neighborhoodprint(aview,a);
	printf("a=%s size=%d\n",aview,neighborhoodsize(a));

	while(a)
	{
		neighborhoodcut(&a);
		neighborhoodprint(aview,a);
		printf("a=%s size=%d\n",aview,neighborhoodsize(a));
	}
}

void graphtest7()
{
	Traffic X;
	Graph G;
	Graph a;
	int i;
	char gview[1000];

	X=traffictest7();
	G=graphoftraffic(X);

	for(a=G,i=1;a;a=a->next,i++)
	{
		a->color=i%2?i:0;
	}
	graphverticesneighborhoods(G);
	graphprint(gview,G);
	printf("G=%s\n",gview);

	while(G) graphcut(&G);
	while(X) trafficdestr(&X);
}

void graphtest8()
{
	Neighborhood a;
	char aview[1000];

	a=neighborhoodconst();
	neighborhoodadd(&a,1);
	neighborhoodadd(&a,1);
	neighborhoodadd(&a,2);
	neighborhoodadd(&a,5);
	neighborhoodadd(&a,5);
	neighborhoodadd(&a,3);
	neighborhoodadd(&a,0);
	neighborhoodadd(&a,-1);
	neighborhoodadd(&a,10);

	neighborhoodprint(aview,a);
	printf("a=%s size=%d firstfree=%d\n",aview,neighborhoodsize(a),neighborhoodfirstfree(a));

	while(a) neighborhoodcut(&a);
}

void graphtest9()
{
	Traffic X;
	Traffic Y;
	Graph G;
	Graph vertex;
	char gview[1000];
	char xview[100];

	X=traffictest7();
	Y=trafficdup(X);
	G=graphoftraffic(Y);

	do
	{
		graphverticesneighborhoods(G);
		graphprint(gview,G);
		printf("Graph=%s\n",gview);
		vertex=graphmostwantedvertex(G);
		if(vertex!=NULL)
		{
			if(vertex->color!=0)
			{
				printf("graphcolor: error, the vertex already have a color.\n");
			}
			vertex->color=neighborhoodfirstfree(vertex->neighbors);
			transferprint(xview,vertex->t);
			printf("Vertex=%s\n",xview);
			printf("Color=%d\n",vertex->color);
		}
		else
		{
			printf("All vertices are colored.\n");
		}
		getchar();
	}
	while(vertex);

	while(G) graphcut(&G);
	while(Y) trafficcut(&Y);
	while(X) trafficdestr(&X);
}

void graphtest10()
{
	Traffic X;
	Traffic Y;
	Graph G;
	char gview[1000];

	X=traffictest7();
	Y=trafficdup(X);
	G=graphoftraffic(Y);

	graphcolor(G);
	graphtransferscolorsprint(gview,G);
	printf("Graph=%s\n",gview);
	printf("Graph is colored %s.\n",graphcoloredok(G)?"well":"not properly");
	printf("Chromaticity=%d\n",graphchromaticity(G));

	while(G) graphcut(&G);
	while(Y) trafficcut(&Y);
	while(X) trafficdestr(&X);
}

void graphtest11()
{
	int nallocs;
	int i;
	Traffic X;
	Graph G;
	int duration;
	int chromaticity;

	nallocs=t1nodeallocsnu();
	for(i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		G=graphoftraffic(X);
		graphcolor(G);
		duration=trafficduration(X);
		chromaticity=graphchromaticity(G);

		printf("alc: %-3d alcsz: %-2d traffsz: %-4d duration: %-3d c=%-3s chromaticity: %-3d %s\n",
			i,t1allocsz(t1nodeallocs[i]),trafficsize(X),duration,
			graphcoloredok(G)?"ok":"ERR",chromaticity,chromaticity==duration?"liquid":"NOT LIQUID");

		while(G) graphcut(&G);
		while(X) trafficdestr(&X);
		//getchar();
	}
}

void graphtest12()
{
	int nallocs;
	int i;
	Traffic X;
	Graph G;
	int duration;
	int chromaticity;

    time_t sec_a;
    time_t sec_b;
	unsigned msec_a;
	unsigned msec_b;
    struct _timeb tstruct;
	long colortm;

	nallocs=t1nodeallocsnu();
	for(i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		G=graphoftraffic(X);
    
		time( &sec_a );
		_ftime( &tstruct );
        msec_a=tstruct.millitm;
		graphcolor(G);
		time( &sec_b );
		_ftime( &tstruct );
        msec_b=tstruct.millitm;
		colortm=(sec_b-sec_a)*1000+(msec_b-msec_a);

		duration=trafficduration(X);
		chromaticity=graphchromaticity(G);

		printf("msec: %-5ld alc: %-3d alcsz: %-2d traffsz: %-4d duration: %-3d c=%-3s chromaticity: %-3d %s\n",
			colortm,i,t1allocsz(t1nodeallocs[i]),trafficsize(X),duration,
			graphcoloredok(G)?"ok":"ERR",chromaticity,chromaticity==duration?"liquid":"NOT LIQUID");

		while(G) graphcut(&G);
		while(X) trafficdestr(&X);
		//getchar();
	}
}