#ifndef GRAPH_H
#define GRAPH_H

#include "transfer.h"
#include "traffic.h"
#include "skeleton.h"
#include "swisst1.h"

typedef struct Neighborhood *Neighborhood;

struct Neighborhood
{
	int color;
	Neighborhood next;
};

typedef struct Graph *Graph;

struct Graph
{
	unsigned long *t;
	int color;
	int degree;
	int neighborhoodsz;
	Neighborhood neighbors;
	Graph next;
};

Graph graphconst();
Graph graphoftraffic(Traffic X);
void graphadd(Graph *G, Transfer x);
void graphcut(Graph *G);
void graphprint(char *s, Graph G);
int graphchromaticity(Graph G);
void graphcolorsprint(char *s, Graph G);
void graphtransferscolorsprint(char *s, Graph G);
int graphnocolorhole(Graph G);
int graphstartcolor(Graph G);
int graphcolored(Graph G);
void graphcolorsreset(Graph G);
void graphverticesdegrees(Graph G);
Neighborhood neighborhoodconst();
void neighborhoodadd(Neighborhood *neighbors, int color);
void neighborhoodcut(Neighborhood *neighbors);
int neighborhoodsize(Neighborhood neighbors);
void graphverticesneighborhoods(Graph G);
void neighborhoodprint(char *s, Neighborhood neighbors);
void graphverticesneighborhoods(Graph G);
Graph graphmostwantedvertex(Graph G);
int neighborhoodfirstfree(Neighborhood neighbors);
void graphcolor(Graph G);
int graphcoloredok(Graph G);

void graphtest1();
void graphtest2();
void graphtest3();
void graphtest4();
void graphtest5();
void graphtest6();
void graphtest7();
void graphtest8();
void graphtest9();
void graphtest10();
void graphtest11();
void graphtest12();
void graphtest13();
void graphtest14();
void graphtest15();
void graphtest16();
void graphtest17();

#endif