#include "skeleton.h"
#include <stdio.h>
#include "swisst1.h"

Traffic trafficskeleton(Traffic X)
{
	Traffic Y;
	Traffic A;
	Transfer a;
	Transfer bottlenecks;

	Y=trafficconst();
	bottlenecks=trafficbottlenecks(X);

	for(A=X;A;A=A->next)
	{
		a=A->t;
		if(transferscongest(a,bottlenecks))
			trafficadd(&Y,a);
	}
	transferdestr(&bottlenecks);
	return Y;
}

Transfer trafficbottlenecks(Traffic X)
{
	int i;
	int load[linknu];
	Traffic A;
	Transfer a;
	int mxload;
	Transfer bottlenecks;

	for(i=0;i<linknu;i++)
		load[i]=0;

	for(A=X;A;A=A->next)
	{
		a=A->t;
		for(i=0;i<linknu;i++)
			if(transfercontains(a,i))
				load[i]++;
	}

	for(mxload=0,i=0;i<linknu;i++)
	{
		if(load[i]>mxload)
			mxload=load[i];
	}

	bottlenecks=transfercreat();
	transferzero(bottlenecks);
	for(i=0;i<linknu;i++)
		if(load[i]==mxload)
			transferadd(bottlenecks,i);
	return bottlenecks;
}

int transfercontains(Transfer a, int i)
{
	if(i>=0 && i<linknu)
		return (a[i/longsz]>>(i%longsz))&1;
	else
		return 0;
}

int trafficduration(Traffic X)
{
	int i;
	int load[linknu];
	Traffic A;
	Transfer a;
	int mxload;

	for(i=0;i<linknu;i++)
		load[i]=0;

	for(A=X;A;A=A->next)
	{
		a=A->t;
		for(i=0;i<linknu;i++)
			if(transfercontains(a,i))
				load[i]++;
	}

	for(mxload=0,i=0;i<linknu;i++)
	{
		if(load[i]>mxload)
			mxload=load[i];
	}
	return mxload;
}

int trafficsize(Traffic X)
{
	int size;
	Traffic A;

	size=0;
	for(A=X;A;A=A->next)
	{
		size++;
	}
	return size;
}

//====tests====

void skeletontest1()
{
	Transfer a;
	int i;
	char s[200];

	a=transfercreat();
	transferadd(a,0);
	transferadd(a,10);
	transferadd(a,5);
	transferadd(a,155);

	transferprint(s,a);

	do
	{
		printf("i:");
		scanf("%d",&i);
		printf("Transfer %s %s %d.\n",s,transfercontains(a,i)?"contains":"doesn't contain",i);
	}
	while(i!=-100);

	transferdestr(&a);
}

void skeletontest2()
{
	int i;
	int nallocs;
	char s[200];
	Traffic X;
	int dur;
	int siz;
	double liq;

	nallocs=t1nodeallocsnu();
	for(i=0;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		dur=trafficduration(X);
		siz=trafficsize(X);
		liq=100.0*siz/dur;

		t1allocprint(s,t1nodeallocs[i]);
		printf("alloc%03d=%s dur=%-3d siz=%-4d liq=%.2f\n",i,s,dur,siz,liq);
		while(X) trafficdestr(&X);
		getchar();
	}
}


#define square(x) ((x)*(x))

void skeletontest3()
{
	int i;
	int nallocs;
	Traffic X;
	int dur;
	int siz;
	double liq;
	double samples[]=
	{
		00000.000, 00100.000, 00200.000, 00300.000, 00400.000, 00416.667, 00500.000, 00400.000, 00450.000, 00514.286,
		00600.000, 00408.333, 00445.455, 00490.000, 00544.444, 00612.500, 00700.000, 00400.000, 00426.667, 00457.143,
		00492.308, 00533.333, 00581.818, 00640.000, 00711.111, 00800.000, 00405.000, 00426.316, 00450.000, 00476.471,
		00506.250, 00540.000, 00578.571, 00623.077, 00675.000, 00736.364, 00810.000, 00900.000, 00416.667, 00434.783,
		00454.545, 00476.190, 00500.000, 00526.316, 00555.556, 00588.235, 00625.000, 00666.667, 00714.286, 00769.231,
		00833.333, 00909.091, 01000.000, 00432.143, 00448.148, 00465.385, 00484.000, 00504.167, 00526.087, 00550.000,
		00576.190, 00605.000, 00636.842, 00672.222, 00711.765, 00756.250, 00806.667, 00864.286, 00930.769, 01008.333,
		01100.000, 00450.000, 00464.516, 00480.000, 00496.552, 00514.286, 00533.333, 00553.846, 00576.000, 00600.000,
		00626.087, 00654.545, 00685.714, 00720.000, 00757.895, 00800.000, 00847.059, 00900.000, 00960.000, 01028.571,
		01107.692, 01200.000, 00469.444, 00497.059, 00512.121, 00528.125, 00545.161, 00563.333, 00582.759, 00603.571,
		00625.926, 00650.000, 00676.000, 00704.167, 00734.783, 00768.182, 00804.762, 00845.000, 00889.474, 00938.889,
		00994.118, 01056.250, 01126.667, 01207.143, 01300.000, 00490.000, 00529.730, 00544.444, 00576.471, 00593.939,
		00612.500, 00632.258, 00653.333, 00675.862, 00700.000, 00725.926, 00753.846, 00784.000, 00816.667, 00852.174,
		00890.909, 00933.333, 00980.000, 01031.579, 01088.889, 01152.941, 01225.000, 01306.667, 01400.000, 00511.364,
		00562.500, 00608.108, 00625.000, 00661.765, 00681.818, 00703.125, 00725.806, 00750.000, 00775.862, 00803.571,
		00833.333, 00865.385, 00900.000, 00937.500, 00978.261, 01022.727, 01071.429, 01125.000, 01184.211, 01250.000,
		01323.529, 01406.250, 01500.000, 00533.333, 00581.818, 00640.000, 00691.892, 00711.111, 00752.941, 00775.758,
		00800.000, 00825.806, 00853.333, 00882.759, 00914.286, 00948.148, 00984.615, 01024.000, 01066.667, 01113.043,
		01163.636, 01219.048, 01280.000, 01347.368, 01422.222, 01505.882, 01600.000, 00602.083, 00656.818, 00722.500,
		00781.081, 00802.778, 00850.000, 00875.758, 00903.125, 00932.258, 00963.333, 00996.552, 01032.143, 01070.370,
		01111.538, 01156.000, 01204.167, 01256.522, 01313.636, 01376.190, 01445.000, 01521.053, 01605.556, 01700.000,
		00675.000, 00736.364, 00810.000, 00875.676, 00900.000, 00952.941, 00981.818, 01012.500, 01045.161, 01080.000,
		01117.241, 01157.143, 01200.000, 01246.154, 01296.000, 01350.000, 01408.696, 01472.727, 01542.857, 01620.000,
		01705.263, 01800.000, 00752.083, 00820.455, 00902.500, 00975.676, 01002.778, 01061.765, 01093.939, 01128.125,
		01164.516, 01203.333, 01244.828, 01289.286, 01337.037, 01388.462, 01444.000, 01504.167, 01569.565, 01640.909,
		01719.048, 01805.000, 01900.000, 00833.333, 00909.091, 01000.000, 01081.081, 01111.111, 01176.471, 01212.121,
		01250.000, 01290.323, 01333.333, 01379.310, 01428.571, 01481.481, 01538.462, 01600.000, 01666.667, 01739.130,
		01818.182, 01904.762, 02000.000, 00918.750, 01002.273, 01102.500, 01191.892, 01225.000, 01297.059, 01336.364,
		01378.125, 01422.581, 01470.000, 01520.690, 01575.000, 01633.333, 01696.154, 01764.000, 01837.500, 01917.391,
		02004.545, 01008.333, 01100.000, 01210.000, 01308.108, 01344.444, 01423.529, 01466.667, 01512.500, 01561.290,
		01613.333, 01668.966, 01728.571, 01792.593, 01861.538, 01936.000, 02016.667, 01102.083, 01202.273, 01322.500,
		01429.730, 01469.444, 01555.882, 01603.030, 01653.125, 01706.452, 01763.333, 01824.138, 01889.286, 01959.259,
		01200.000, 01309.091, 01440.000, 01556.757, 01600.000, 01694.118, 01745.455, 01800.000, 01858.065, 01920.000,
		01986.207, 02057.143, 02133.333, 01302.083, 01420.455, 01562.500, 01689.189, 01736.111, 01838.235, 01893.939,
		01953.125, 01408.333, 01536.364, 01690.000, 01827.027, 01877.778, 01988.235, 02048.485, 01518.750, 01656.818,
		01822.500, 01970.270, 02025.000, 01633.333, 01781.818, 01960.000, 02118.919, 01752.083, 01911.364, 01875.000,
		02045.455, 02002.083, 02133.333
	};
	double error;

	nallocs=t1nodeallocsnu();
	error=0;
	for(i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);

		dur=trafficduration(X);
		siz=trafficsize(X);
		liq=100.0*siz/dur;
		error+=square(liq-samples[i]);

		while(X) trafficdestr(&X);
	}
	printf("Aggregate Error = %.10f\n",error);
}


void skeletontest4()
{
	int i;
	int nallocs;
	char allocview[200];
	char bottlview[200];
	Traffic X;
	int dur;
	int siz;
	Transfer bottlenecks;

	nallocs=t1nodeallocsnu();
	for(i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		dur=trafficduration(X);
		siz=trafficsize(X);
		bottlenecks=trafficbottlenecks(X);

		t1allocprint(allocview,t1nodeallocs[i]);
		transferprint(bottlview,bottlenecks);
		printf("alloc%03d=%s dur=%-3d siz=%-4d bottlenecks=%s\n",i,allocview,dur,siz,bottlview);
		while(X) trafficdestr(&X);
		transferdestr(&bottlenecks);
		getchar();
	}
}

void skeletontest5()
{
	int i;
	int nallocs;
	char Xview[50000];
	char Skview[50000];
	Traffic X;
	Traffic Sk;

	nallocs=t1nodeallocsnu();
	for(i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		Sk=trafficskeleton(X);

		trafficprint(Xview,X);
		trafficprint(Skview,Sk);
		printf("X%d=%s\n",i,Xview);
		printf("Sk%d=%s\n",i,Skview);

		while(Sk) trafficcut(&Sk);
		while(X) trafficdestr(&X);
		getchar();
	}
}

void skeletontest6()
{
	int i;
	int nallocs;
	Traffic X;
	Traffic Sk;
	int Xsz;
	int Sksz;

	nallocs=t1nodeallocsnu();
	for(i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		Sk=trafficskeleton(X);

		Xsz=trafficsize(X);
		Sksz=trafficsize(Sk);
		printf("alloc=%-3d #(X)=%-4d #(Sk)=%-4d nnode=%-2d Skcontent=%.1f%c\n",
			i,Xsz,Sksz,t1allocsz(t1nodeallocs[i]),100.0*Sksz/Xsz,'%');
		//printf("%d, %.2f\n",i,100.0*Sksz/Xsz);

		while(Sk) trafficcut(&Sk);
		while(X) trafficdestr(&X);
		getchar();
	}
}

void skeletontest7()
{
	int i;
	int nallocs;
	Traffic X;
	Traffic Sk;
	int Xsz;
	int Sksz;
	int n;

	nallocs=t1nodeallocsnu();
	for(n=0,i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		Sk=trafficskeleton(X);

		Xsz=trafficsize(X);
		Sksz=trafficsize(Sk);
		if(Sksz!=Xsz)
		{
			printf("%d, %.2f\n",t1allocsz(t1nodeallocs[i]),100.0*Sksz/Xsz);
			n++;
		}

		while(Sk) trafficcut(&Sk);
		while(X) trafficdestr(&X);
	}
	printf("n=%d\n",n);
}
