#include "swisst1.h"
#include <stdio.h>
#include <math.h>
#include <string.h>

int t1allocsz(t1alloc n)
{
	int i;
	int sz;

	sz=0;
	for(i=0;i<t1swnu;i++)
	{
		sz+=n[i];
	}
	return sz;
}

void t1allocprint(char *s, t1alloc n)
{
	int i;
	char tmp[64];

	strcpy(s,"{");
	for(i=0;i<t1swnu;i++)
	{
		if(i!=0)
			strcat(s,",");
		sprintf(tmp,"%d",n[i]);
		strcat(s,tmp);
	}
	strcat(s,"}");
}

Traffic t1node2node(t1alloc nodes)
{
	Traffic X;
	int sw1;
	int sw2;
	int i1;
	int i2;
	int pr1;
	int pr2;
	Transfer a;

	X=trafficconst();
	for(sw1=0;sw1<t1swnu;sw1++)
		if(!(nodes[sw1]>=0 && nodes[sw1]<=4))
			return X;
	for(sw1=0;sw1<t1swnu;sw1++)
		for(i1=0;i1<nodes[sw1];i1++)
			for(sw2=0;sw2<8;sw2++)
				for(i2=0;i2<nodes[sw2];i2++)
				{
					pr1=sw1*8+i1*2;
					pr2=sw2*8+i2*2+1;
					a=t1prpr(pr1,pr2);
					trafficadd(&X,a);
				}
	return X;
}

int t1swofpr(int pr)
{
	int sw=0;
	sw=pr/8;
	return sw;
}

int t1swofswsw(int sw1, int sw3)
{
	int sw2=0;
	static int routing[t1swnu][t1swnu]=
	{
		{0,1,1,3,3,5,7,7},
		{0,1,2,6,4,2,6,4},
		{1,1,2,3,3,5,7,7},
		{0,6,2,3,4,6,6,2},
		{3,1,3,3,4,5,5,7},
		{0,2,2,6,4,5,6,0},
		{7,1,7,3,5,5,6,7},
		{0,4,2,2,4,0,6,7}
	};
	sw2=routing[sw1][sw3];
	return sw2;
}

int t1lnofswsw(sw1,sw2)
{
	int shift;
	int betwlink;

	shift=(t1swnu+sw2-sw1)%t1swnu;
	if(!(shift%2))
		return -1;
	betwlink=t1prnu+sw1*4+shift/2;
	return betwlink;
}

void t1linksofswsw(int sw1, int sw3, Transfer a)
{
	int sw2;
	int link1;
	int link2;

	sw2=t1swofswsw(sw1,sw3);
	if(sw2==sw1 && sw2==sw3)
		return;
	else if(sw2==sw1 || sw2==sw3)
	{
		link1=t1lnofswsw(sw1,sw3);
		transferadd(a,link1);
	}
	else
	{
		link1=t1lnofswsw(sw1,sw2);
		link2=t1lnofswsw(sw2,sw3);
		transferadd(a,link1);
		transferadd(a,link2);
	}
}

Transfer t1prpr(int pr1, int pr2)
{
	Transfer a;
	int sw1;
	int sw2;

	a=transfercreat();
	transferzero(a);
	if(pr1>=0 && pr1<t1prnu && pr2>=0 && pr2<t1prnu)
	{
		transferadd(a,pr1);
		sw1=t1swofpr(pr1);
		sw2=t1swofpr(pr2);
		t1linksofswsw(sw1,sw2,a);
		transferadd(a,t1prnu+t1lnnu+pr2);
	}
	return a;
}

//=====tests=====

void swisst1test1()
{
	int sw1;
	int sw2;
	int link;

	for(sw1=0;sw1<8;sw1++)
	{
		for(sw2=0;sw2<8;sw2++)
		{
			link=t1lnofswsw(sw1,sw2);
			if(sw2!=0)
				printf(", ");
			printf("%d",link);
		}
		printf("\n");
	}
}

void swisst1test2()
{
	int sw1;
	int sw2;
	int sw3;

	for(sw1=0;sw1<8;sw1++)
	{
		for(sw3=0;sw3<8;sw3++)
		{
			if(sw3!=0)
				printf(" ");
			sw2=t1swofswsw(sw1,sw3);
			if(sw2==sw1 && sw2==sw3)
			{
				printf("L");
			}
			else if(sw2==sw1 || sw2==sw3)
			{
				printf("D");
			}
			else
			{
				printf("I");
			}
		}
		printf("\n");
	}
}

void swisst1test3()
{
	int sw1;
	int sw2;
	int sw3;
	int link;

	for(sw1=0;sw1<8;sw1++)
	{
		for(sw3=0;sw3<8;sw3++)
		{
			if(sw3!=0)
				printf(" ");
			sw2=t1swofswsw(sw1,sw3);
			link=t1lnofswsw(sw1,sw3);
			if(sw2==sw1 && sw2==sw3)
			{
				if(link==-1)
					printf(":");
				else
					printf("X");
			}
			else if(sw2==sw1 || sw2==sw3)
			{
				if(link!=-1)
					printf("*");
				else
					printf("X");
			}
			else
			{
				if(link==-1)
					printf(".");
				else
					printf("X");
			}
		}
		printf("\n");
	}
}

void swisst1test4()
{
	int sw1;
	int sw2;
	int link;

	for(sw1=0;sw1<8;sw1++)
	{
		for(sw2=0;sw2<8;sw2++)
		{
			link=t1lnofswsw(sw1,sw2);
			if(sw2!=0)
				printf(" ");
			if(link==-1)
				printf("   ");
			else
				printf("%3d",link);
		}
		printf("\n");
	}
}

void swisst1test5()
{
	int sw1;
	int sw2;
	Transfer a;
	char s[1024];

	a=transfercreat();
	for(sw1=0;sw1<8;sw1++)
	{
		for(sw2=0;sw2<8;sw2++)
		{
			if(sw2!=0) printf(" ");
			transferzero(a);
			t1linksofswsw(sw1,sw2,a);
			transferprint(s,a);
			printf("%9s",s);
		}
		printf("\n");
	}
	transferdestr(&a);
}

void swisst1test6()
{
	int pr1;
	int pr2;
	Transfer a;
	char s[1024];

	while(1)
	{
		printf("pr1: ");
		scanf("%d",&pr1);
		printf("pr2: ");
		scanf("%d",&pr2);
		a=t1prpr(pr1,pr2);
		transferprint(s,a);
		printf("Transfer=%s\n",s);
		transferdestr(&a);
	}
}

void swisst1test7()
{
	int sw;
	t1alloc nodes;
	Traffic X;
	char s[10000];

	for(sw=0;sw<t1swnu;sw++)
	{
		printf("nodes[%d]=",sw);
		scanf("%d",&(nodes[sw]));
	}
	X=t1node2node(nodes);
	trafficprint(s,X);
	printf("X=%s\n",s);
	while(X) trafficdestr(&X);
}

void swisst1test8()
{
	int nallocs;
	int i;
	Traffic X;
	char s[50000];

	nallocs=t1nodeallocsnu();
	for(i=0;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		trafficprint(s,X);
		printf("X%d=%s\n",i,s);
		while(X) trafficdestr(&X);
		getchar();
	}
}

void swisst1test9()
{
	int nallocs;
	int i;
	Traffic X;
	Category R;

	nallocs=t1nodeallocsnu();
	for(i=0;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		R=primcategory(X);
		categorytest5a(&R);
		while(X) trafficdestr(&X);
		getchar();
	}
}

void swisst1test10()
{
	int nallocs;
	int i;
	Traffic X;
	Category R;
	long nblank;
	long ndead;
	long ncovered;
	double complexity;

	nallocs=t1nodeallocsnu();
	for(i=49;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		R=primcategory(X);
		nblank=0;
		blankfissionsz(&R,&nblank);
		R=primcategory(X);
		ndead=0;
		deadfissionsz(&R,&ndead);
		R=primcategory(X);
		ncovered=0;
		coveragesz(&R,&ncovered);
		while(X) trafficdestr(&X);
		complexity=ncovered*log10(ncovered);
		printf("alc: %-3d csz: %-9d bfsz: %-10d dfsz: %-10d bc: %-5.2f dc: %-5.2f\n",
			i,ncovered,nblank,ndead,nblank/complexity,ndead/complexity);
		//getchar();
	}
}

/*
alc: 0   csz: 1         bfsz: 1          dfsz: 1          bc: 1.#J  dc: 1.#J
alc: 1   csz: 1         bfsz: 3          dfsz: 3          bc: 1.#J  dc: 1.#J
alc: 2   csz: 2         bfsz: 11         dfsz: 13         bc: 18.27 dc: 21.59
alc: 3   csz: 6         bfsz: 51         dfsz: 67         bc: 10.92 dc: 14.35
alc: 4   csz: 24        bfsz: 291        dfsz: 417        bc: 8.78  dc: 12.59
alc: 5   csz: 84        bfsz: 1297       dfsz: 2419       bc: 8.02  dc: 14.97
alc: 6   csz: 120       bfsz: 2003       dfsz: 3091       bc: 8.03  dc: 12.39
alc: 7   csz: 360       bfsz: 7359       dfsz: 16333      bc: 8.00  dc: 17.75
alc: 8   csz: 432       bfsz: 9255       dfsz: 18637      bc: 8.13  dc: 16.37
alc: 9   csz: 666       bfsz: 10659      dfsz: 20263      bc: 5.67  dc: 10.78
alc: 10  csz: 720       bfsz: 16203      dfsz: 26653      bc: 7.88  dc: 12.96
alc: 11  csz: 1872      bfsz: 49235      dfsz: 128307     bc: 8.04  dc: 20.95
alc: 12  csz: 3384      bfsz: 58931      dfsz: 142563     bc: 4.93  dc: 11.94
alc: 13  csz: 2640      bfsz: 75557      dfsz: 165363     bc: 8.36  dc: 18.31
alc: 14  csz: 4272      bfsz: 87299      dfsz: 180307     bc: 5.63  dc: 11.63
alc: 15  csz: 5328      bfsz: 96327      dfsz: 197427     bc: 4.85  dc: 9.94
alc: 16  csz: 5040      bfsz: 150531     dfsz: 261843     bc: 8.07  dc: 14.03
alc: 17  csz: 9792      bfsz: 338195     dfsz: 1020289    bc: 8.65  dc: 26.11
alc: 18  csz: 11520     bfsz: 413201     dfsz: 1154257    bc: 8.83  dc: 24.67
alc: 19  csz: 21888     bfsz: 492277     dfsz: 1285489    bc: 5.18  dc: 13.53
alc: 20  csz: 26112     bfsz: 505105     dfsz: 1260337    bc: 4.38  dc: 10.93
alc: 21  csz: 35712     bfsz: 673983     dfsz: 1600177    bc: 4.15  dc: 9.84
alc: 22  csz: 40824     bfsz: 866669     dfsz: 1754305    bc: 4.60  dc: 9.32
alc: 23  csz: 35136     bfsz: 691143     dfsz: 1554465    bc: 4.33  dc: 9.73
alc: 24  csz: 44928     bfsz: 1081399    dfsz: 2137537    bc: 5.17  dc: 10.23
alc: 25  csz: 38880     bfsz: 789403     dfsz: 1777041    bc: 4.42  dc: 9.96
alc: 26  csz: 60480     bfsz: 2821915    dfsz: 9256867    bc: 9.76  dc: 32.01
alc: 27  csz: 124416    bfsz: 3165311    dfsz: 10373539   bc: 4.99  dc: 16.37
alc: 28  csz: 90720     bfsz: 2721035    dfsz: 8979715    bc: 6.05  dc: 19.97
alc: 29  csz: 162432    bfsz: 3352249    dfsz: 9946243    bc: 3.96  dc: 11.75
alc: 30  csz: 254016    bfsz: 5416547    dfsz: 14546083   bc: 3.95  dc: 10.59
alc: 31  csz: 222912    bfsz: 5418811    dfsz: 13003267   bc: 4.55  dc: 10.91
alc: 32  csz: 324864    bfsz: 8255613    dfsz: 17844163   bc: 4.61  dc: 9.97
alc: 33  csz: 332928    bfsz: 8217617    dfsz: 17617187   bc: 4.47  dc: 9.58
alc: 34  csz: 256608    bfsz: 6185173    dfsz: 16266883   bc: 4.46  dc: 11.72
alc: 35  csz: 170208    bfsz: 4063597    dfsz: 12302371   bc: 4.56  dc: 13.82
alc: 36  csz: 368352    bfsz: 9269739    dfsz: 21000547   bc: 4.52  dc: 10.24
alc: 37  csz: 406368    bfsz: 9667867    dfsz: 22171267   bc: 4.24  dc: 9.73
alc: 38  csz: 222336    bfsz: 13136199   dfsz: 58049997   bc: 11.05 dc: 48.83
alc: 39  csz: 789696    bfsz: 18744193   dfsz: 77525229   bc: 4.02  dc: 16.65
alc: 40  csz: 800064    bfsz: 20652043   dfsz: 80391741   bc: 4.37  dc: 17.02
alc: 41  csz: 1111680   bfsz: 25010733   dfsz: 88996717   bc: 3.72  dc: 13.24
alc: 42  csz: 1987200   bfsz: 49603379   dfsz: 147829101  bc: 3.96  dc: 11.81
alc: 43  csz: 2400192   bfsz: 67352955   dfsz: 163975581  bc: 4.40  dc: 10.71
alc: 44  csz: 1291968   bfsz: 33757087   dfsz: 97607661   bc: 4.28  dc: 12.36
alc: 45  csz: 1095552   bfsz: 30304707   dfsz: 108824493  bc: 4.58  dc: 16.45
alc: 46  csz: 1807488   bfsz: 52566819   dfsz: 160881357  bc: 4.65  dc: 14.23
alc: 47  csz: 1833408   bfsz: 50621937   dfsz: 139986669  bc: 4.41  dc: 12.19
alc: 48  csz: 3144384   bfsz: 97639081   dfsz: 221456253  bc: 4.78  dc: 10.84
alc: 49  csz: 3256512   bfsz: 97343555   dfsz: 219193661  bc: 4.59  dc: 10.34
alc: 50  csz: 1677888   bfsz: 53002817   dfsz: 158483037  bc: 5.07  dc: 15.17
alc: 51  csz: 3582144   bfsz: 105084931  dfsz: 245238093  bc: 4.48  dc: 10.45
alc: 52  csz: 3684288   bfsz: 98948679   dfsz: 246754045  bc: 4.09  dc: 10.20
alc: 53  csz: 971136    bfsz: 73076411   dfsz: 407447971  bc: 12.57 dc: 70.07
alc: 54  csz: 4936896   bfsz: 126721725  dfsz: 629556883  bc: 3.83  dc: 19.05
alc: 55  csz: 5809536   bfsz: 151637191  dfsz: 669871843  bc: 3.86  dc: 17.05
alc: 56  csz: 5019840   bfsz: 142130169  dfsz: 665565043  bc: 4.23  dc: 19.79
alc: 57  csz: 10482048  bfsz: 284514943  dfsz: 1092858531 bc: 3.87  dc: 14.85
alc: 58  csz: 16773696  bfsz: 468653289  dfsz: 1416238339 bc: 3.87  dc: 11.69
alc: 59  csz: 5624640   bfsz: 185694077  dfsz: 849063891  bc: 4.89  dc: 22.36
alc: 60  csz: 19730304  bfsz: 464048515  dfsz: 1593377443 bc: 3.22  dc: 11.07
alc: 61  csz: 17836416  bfsz: 567537903  dfsz: 1906714531 bc: 4.39  dc: 14.74
alc: 62  csz: 24985152  bfsz: 886643757  dfsz: -2054643357 bc: 4.80  dc: -11.12
*/

void swisst1test11()
{
	__int64 a=2240323939;
	printf("%d\n",a);
}

/*
-2054643357
*/

void swisst1test12()
{
	int sw1;
	int sw2;
	int sw3;

	for(sw1=0;sw1<8;sw1++)
	{
		printf("%d",sw1+1);
		for(sw2=0;sw2<8;sw2++)
		{
			sw3=t1swofswsw(sw1,sw2);
			if((sw3!=sw1)&&(sw3!=sw2))
				printf(" %d",sw3+1);
			else if((sw3==sw1)&&(sw3==sw2))
				printf(" *");
			else if((sw3==sw1)||(sw3==sw2))
				printf(" -");
		}
		printf("\n");
	}
}

void swisst1test13()
{
	int nallocs;
	int i;
	Traffic X;
	Traffic Y;
	int edgenu;
	Transfer t;
	Traffic a;

	nallocs=t1nodeallocsnu();
	for(i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		Y=trafficdup(X);
		edgenu=0;
		while(Y)
		{
			t=Y->t;
			trafficcut(&Y);
			for(a=Y;a;a=a->next)
				if(transferscongest(t,a->t))
					edgenu++;
		}
		printf("alc: %-3d alcsz: %-2d traffsz: %-4d graphedges: %d\n",
			i,t1allocsz(t1nodeallocs[i]),trafficsize(X),edgenu);
		while(X) trafficdestr(&X);
		//getchar();
	}
}

void swisst1test14()
{
	int nallocs;
	int i;
	Traffic X;
	char s[64*1024];

	nallocs=t1nodeallocsnu();
	for(i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		trafficprint(s,X);

		printf("alc: %-3d alcsz: %-2d traffsz: %-4d transfer: %s\n",
			i,t1allocsz(t1nodeallocs[i]),trafficsize(X),s);

		while(X) trafficdestr(&X);
		getchar();
	}
}
