#include "team.h"
#include <stdio.h>
#include "swisst1.h"

void infodestr(FissionInfo *info)
{
	if((info->bottlenecks)!=NULL) transferdestr(&(info->bottlenecks));
	info->fissionsz=0;
	info->solutionsz=0;
	while(info->X) trafficcut(&(info->X));
	info->skeleton=0;
}

void infonull(FissionInfo *info)
{
	info->bottlenecks=NULL;
	info->fissionsz=0;
	info->solutionsz=0;
	info->X=NULL;
	info->skeleton=0;
}

void infoconst(FissionInfo *info, Traffic X)
{
	info->bottlenecks=trafficbottlenecks(X);
	info->fissionsz=0;
	info->solutionsz=0;
	info->X=trafficdup(X);
	info->skeleton=1;
}

void blankfissioninfo(Category *R, FissionInfo *info)
{
	Category Rpos;

	(info->fissionsz)++;
	if(blank(R))
	{
		categorydestr(R);
		return;
	}
	if(singular(R))
	{
		(info->solutionsz)++;
		categorydestr(R);
		return;
	}

	Rpos=fission(R);
	blankfissioninfo(&Rpos,info);
	blankfissioninfo(R,info);
	return;
}

void skeletonfissioninfo(Category *R, FissionInfo *info)
{
	Category Rpos;
	FissionInfo subinfo;

	(info->fissionsz)++;
	if(blank(R))
	{
		categorydestr(R);
		return;
	}
	if(info->skeleton)
		if(idle(R,info->bottlenecks))
		{
			categorydestr(R);
			return;
		}
	if(singular(R))
	{
		if(info->skeleton)
		{
			R->depot=noncongestings_wtraffic(info->X,R->includer);
			infonull(&subinfo);
			skeletonfissioninfo(R,&subinfo);
			info->fissionsz+=subinfo.fissionsz;
			info->solutionsz+=subinfo.solutionsz;
			return;
		}
		else
		{
			(info->solutionsz)++;
			categorydestr(R);
			return;
		}
	}

	Rpos=fission(R);
	skeletonfissioninfo(&Rpos,info);
	skeletonfissioninfo(R,info);
	return;
}

void idlefissioninfo(Category *R, FissionInfo *info)
{
	Category Rpos;

	(info->fissionsz)++;
	if(blank(R))
	{
		categorydestr(R);
		return;
	}
	if(idle(R,info->bottlenecks))
	{
		categorydestr(R);
		return;
	}
	if(singular(R))
	{
		(info->solutionsz)++;
		categorydestr(R);
		return;
	}

	Rpos=fission(R);
	idlefissioninfo(&Rpos,info);
	idlefissioninfo(R,info);
	return;
}

Transfer transferdup(Transfer a)
{
	int i;
	Transfer b;

	b=transfercreat();
	for(i=0;i<longnu;i++)
		b[i]=a[i];
	return b;
}

int transferempty(Transfer a)
{
	int i;
	for(i=0;i<longnu;i++)
		if(a[i])
			return 0;
	return 1;
}

void transferclear(Transfer a, Transfer b)
{
	int i;
	for(i=0;i<longnu;i++)
		a[i]&=~b[i];
}


int idle(Category *R, Transfer bottlenecks)
{
	Transfer a;
	Traffic A;
	int itseems=1;

	a=transferdup(bottlenecks);
	for(A=R->includer;itseems && A;A=A->next)
	{
		transferclear(a,A->t);
		if(transferempty(a))
			itseems=0;
	}
	for(A=R->depot;itseems && A;A=A->next)
	{
		transferclear(a,A->t);
		if(transferempty(a))
			itseems=0;
	}
	transferdestr(&a);
	return itseems;
}


//====tests====

void teamtest1()
{
	Transfer a;
	Transfer b;
	char aview[200];
	char bview[200];

	a=transfercreat();
	transferadd(a,0);
	transferadd(a,159);
	transferadd(a,30);
	b=transferdup(a);
	transferadd(a,32);

	transferprint(aview,a);
	transferprint(bview,b);
	printf("a=%s\n",aview);
	printf("b=%s\n",bview);

	transferdestr(&a);
	transferdestr(&b);
}

void teamtest2()
{
	Transfer a;
	char aview[200];

	a=transfercreat();

	transferprint(aview,a);
	printf("Transfer %s is%sempty\n",aview,transferempty(a)?" ":" not ");

	transferadd(a,159);
	transferprint(aview,a);
	printf("Transfer %s is%sempty\n",aview,transferempty(a)?" ":" not ");

	transferadd(a,33);
	transferprint(aview,a);
	printf("Transfer %s is%sempty\n",aview,transferempty(a)?" ":" not ");
	
	transferzero(a);
	transferprint(aview,a);
	printf("Transfer %s is%sempty\n",aview,transferempty(a)?" ":" not ");

	transferadd(a,0);
	transferprint(aview,a);
	printf("Transfer %s is%sempty\n",aview,transferempty(a)?" ":" not ");

	transferdestr(&a);
}

void teamtest3()
{
	Transfer a;
	Transfer b;
	char aview[200];
	char bview[200];
	char clrview[200];

	a=transfercreat();
	b=transfercreat();
	transferadd(a,0);
	transferadd(a,1);
	transferadd(a,2);
	transferadd(a,10);
	transferadd(a,20);
	transferadd(a,100);
	transferadd(a,159);
	transferadd(b,1);
	transferadd(b,10);
	transferadd(b,159);

	transferprint(aview,a);
	transferprint(bview,b);
	transferclear(a,b);
	transferprint(clrview,a);
	printf("Clearance of %s by %s is %s\n",aview,bview,clrview);

	transferdestr(&a);
	transferdestr(&b);
}

void teamtest4()
{
	Traffic X;
	Traffic Y;
	Category R;
	Transfer a;
	char s[20000];
	int isidle=1;

	X=trafficconst();
	Y=trafficconst();
	R=categoryconst();
	a=transfercreat();

	trafficcreat(&X);
		transferadd(X->t,1);
		transferadd(X->t,11);
		transferadd(X->t,9);
	trafficcreat(&X);
		transferadd(X->t,4);
		transferadd(X->t,10);
	trafficcreat(&Y);
		transferadd(Y->t,5);
		transferadd(Y->t,12);
		transferadd(Y->t,6);
	trafficcreat(&Y);
		transferadd(Y->t,3);
		transferadd(Y->t,7);

	transferadd(a,11);
	transferadd(a,12);

	R.includer=trafficdup(X);
	R.depot=trafficdup(Y);
	categoryprint(s,R);
	isidle=idle(&R,a);
	printf("Category %s is%sidle.\n",s,isidle?" ":" not ");

	categorydestr(&R);
	transferdestr(&a);
	while(X) trafficdestr(&X);
	while(Y) trafficdestr(&Y);
}

void teamtest5()
{
	Traffic X;
	Category R;
	Transfer bottlenecks;
	char s[10000];

	X=trafficconst();
	X=traffictest7();
	trafficprint(s,X);
	printf("X=%s\n\n",s);
	R=primcategory(X);
	bottlenecks=trafficbottlenecks(X);

	teamtest5a(&R,bottlenecks);

	categoryprint(s,R);
	printf("R=%s\n",s);
	transferdestr(&bottlenecks);
	categorydestr(&R);
	while(X) trafficdestr(&X);
}

void teamtest5a(Category *R, Transfer bottlenecks)
{
	static int i=1;
	Category Rpos;
	char s[5000];

	if(singular(R))
	{
		trafficprint(s,R->includer);
		printf("Team%d=%s\n",i++,s);
		categorydestr(R);
		return;
	}
	if(blank(R))
	{
		categorydestr(R);
		return;
	}
	if(idle(R,bottlenecks))
	{
		categorydestr(R);
		return;
	}

	Rpos=fission(R);
	teamtest5a(&Rpos,bottlenecks);
	teamtest5a(R,bottlenecks);
	return;
}

void teamtest6()
{
	Traffic X;
	Category R;
	FissionInfo info;

	X=trafficconst();
	X=traffictest7();
	R=primcategory(X);
	info.bottlenecks=trafficbottlenecks(X);
	info.fissionsz=0;
	info.solutionsz=0;

	idlefissioninfo(&R,&info);
	printf("solutionsz=%d, fissionsz=%d\n",info.solutionsz,info.fissionsz);

	transferdestr(&(info.bottlenecks));
	categorydestr(&R);
	while(X) trafficdestr(&X);
}

void teamtest7()
{
	Traffic X;
	Category R;
	FissionInfo info;
	int i;
	int nallocs;

	nallocs=t1nodeallocsnu();
	for(i=60;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		R=primcategory(X);
		info.bottlenecks=trafficbottlenecks(X);
		info.fissionsz=0;
		info.solutionsz=0;

		idlefissioninfo(&R,&info);
		printf("alloc: %-3d sz: %-2d solutionsz: %-10d fissionsz: %-10d\n",
			i,t1allocsz(t1nodeallocs[i]),info.solutionsz,info.fissionsz);

		transferdestr(&(info.bottlenecks));
		categorydestr(&R);
		while(X) trafficdestr(&X);
	}	
}

/*
alloc: 1   sz: 1  solutionsz: 1          fissionsz: 3
alloc: 2   sz: 2  solutionsz: 2          fissionsz: 9
alloc: 3   sz: 3  solutionsz: 6          fissionsz: 31
alloc: 4   sz: 4  solutionsz: 24         fissionsz: 129
alloc: 5   sz: 5  solutionsz: 72         fissionsz: 895
alloc: 6   sz: 5  solutionsz: 120        fissionsz: 651
alloc: 7   sz: 6  solutionsz: 324        fissionsz: 5239
alloc: 8   sz: 6  solutionsz: 384        fissionsz: 6545
alloc: 9   sz: 6  solutionsz: 528        fissionsz: 6597
alloc: 10  sz: 6  solutionsz: 720        fissionsz: 3913
alloc: 11  sz: 7  solutionsz: 1728       fissionsz: 36177
alloc: 12  sz: 7  solutionsz: 2964       fissionsz: 41439
alloc: 13  sz: 7  solutionsz: 2400       fissionsz: 53351
alloc: 14  sz: 7  solutionsz: 3576       fissionsz: 55391
alloc: 15  sz: 7  solutionsz: 4224       fissionsz: 63879
alloc: 16  sz: 7  solutionsz: 5040       fissionsz: 27399
alloc: 17  sz: 8  solutionsz: 9216       fissionsz: 257185
alloc: 18  sz: 8  solutionsz: 10800      fissionsz: 312231
alloc: 19  sz: 8  solutionsz: 19776      fissionsz: 356373
alloc: 20  sz: 8  solutionsz: 21936      fissionsz: 340189
alloc: 21  sz: 8  solutionsz: 31104      fissionsz: 486993
alloc: 22  sz: 8  solutionsz: 32976      fissionsz: 550255
alloc: 23  sz: 8  solutionsz: 26688      fissionsz: 424389
alloc: 24  sz: 8  solutionsz: 33744      fissionsz: 561835
alloc: 25  sz: 8  solutionsz: 9216       fissionsz: 68033
alloc: 26  sz: 9  solutionsz: 57600      fissionsz: 2196113
alloc: 27  sz: 9  solutionsz: 115920     fissionsz: 2416357
alloc: 28  sz: 9  solutionsz: 88128      fissionsz: 2156853
alloc: 29  sz: 9  solutionsz: 136656     fissionsz: 2297739
alloc: 30  sz: 9  solutionsz: 230400     fissionsz: 3998871
alloc: 31  sz: 9  solutionsz: 186192     fissionsz: 3881185
alloc: 32  sz: 9  solutionsz: 276288     fissionsz: 5295305
alloc: 33  sz: 9  solutionsz: 254544     fissionsz: 4724471
alloc: 34  sz: 9  solutionsz: 162432     fissionsz: 4164573
alloc: 35  sz: 9  solutionsz: 94968      fissionsz: 2839911
alloc: 36  sz: 9  solutionsz: 246336     fissionsz: 4607519
alloc: 37  sz: 9  solutionsz: 157536     fissionsz: 991547
alloc: 38  sz: 10 solutionsz: 211968     fissionsz: 9991073
alloc: 39  sz: 10 solutionsz: 693216     fissionsz: 13775725
alloc: 40  sz: 10 solutionsz: 681984     fissionsz: 15165773
alloc: 41  sz: 10 solutionsz: 936000     fissionsz: 19483863
alloc: 42  sz: 10 solutionsz: 1843200    fissionsz: 37073545
alloc: 43  sz: 10 solutionsz: 2145600    fissionsz: 48525751
alloc: 44  sz: 10 solutionsz: 1126656    fissionsz: 25600709
alloc: 45  sz: 10 solutionsz: 753696     fissionsz: 22503673
alloc: 46  sz: 10 solutionsz: 1234944    fissionsz: 36357557
alloc: 47  sz: 10 solutionsz: 1379808    fissionsz: 32777807
alloc: 48  sz: 10 solutionsz: 2367744    fissionsz: 54587553
alloc: 49  sz: 10 solutionsz: 2201568    fissionsz: 48335965
alloc: 50  sz: 10 solutionsz: 466560     fissionsz: 17336631
alloc: 51  sz: 10 solutionsz: 2233296    fissionsz: 51371675
alloc: 52  sz: 10 solutionsz: 1168320    fissionsz: 7362553
alloc: 53  sz: 11 solutionsz: 926208     fissionsz: 54402865
alloc: 54  sz: 11 solutionsz: 4217184    fissionsz: 92755659
alloc: 55  sz: 11 solutionsz: 4877568    fissionsz: 118279365
alloc: 56  sz: 11 solutionsz: 4106592    fissionsz: 103306151
alloc: 57  sz: 11 solutionsz: 9225216    fissionsz: 209509451
alloc: 58  sz: 11 solutionsz: 14215392   fissionsz: 336382121
alloc: 59  sz: 11 solutionsz: 4224384    fissionsz: 139277073
alloc: 60  sz: 11 solutionsz: 15188544   fissionsz: 338048201
alloc: 61  sz: 11 solutionsz: 14114304   fissionsz: 403187525
alloc: 62  sz: 11 solutionsz: 20373984   fissionsz: 586219945
alloc: 63  sz: 11 solutionsz: 8795520    fissionsz: 221286705
*/

void teamtest8()
{
	Traffic X;
	Traffic Sk;
	Transfer bnecks;
	Transfer skbnecks;
	int i;
	int nallocs;

	nallocs=t1nodeallocsnu();
	for(i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		Sk=trafficskeleton(X);
		bnecks=trafficbottlenecks(X);
		skbnecks=trafficbottlenecks(Sk);
		//transferadd(skbnecks,0);

		if(transfereq(bnecks,skbnecks))
		{
			printf("%3d: OK\n",i);
		}
		else
		{
			printf("%3d: ERR\n",i);
			break;
		}

		transferdestr(&bnecks);
		transferdestr(&skbnecks);
		while(Sk) trafficcut(&Sk);
		while(X) trafficdestr(&X);
	}	
}

void teamtest9()
{
	Traffic X;
	Category R;
	Transfer bottlenecks;

	X=t1node2node(t1nodeallocs[20]);
	R=primcategory(X);
	bottlenecks=trafficbottlenecks(X);

	teamtest9a(&R,bottlenecks);

	transferdestr(&bottlenecks);
	categorydestr(&R);
	while(X) trafficdestr(&X);
}

void teamtest9a(Category *R, Transfer bottlenecks)
{
	static int i=0;
	Category Rpos;
	Transfer a;
	Traffic A;
	int ok;

	if(singular(R))
	{
		i++;
		a=transferdup(bottlenecks);
		ok=0;
		for(A=R->includer;A;A=A->next)
		{
			transferclear(a,A->t);
			if(transferempty(a))
			{
				ok=1;
				break;
			}
		}
		if(ok!=1)
			printf("X");
		else
			if(i%50==0)
				printf(".");
		transferdestr(&a);
		categorydestr(R);
		return;
	}
	if(blank(R))
	{
		categorydestr(R);
		return;
	}
	if(idle(R,bottlenecks))
	{
		categorydestr(R);
		return;
	}

	Rpos=fission(R);
	teamtest9a(&Rpos,bottlenecks);
	teamtest9a(R,bottlenecks);
	return;
}

void teamtest10()
{
	Traffic X;
	Category R;
	FissionInfo info;
	int nallocs;
	int i;

	nallocs=t1nodeallocsnu();
	for(i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		R=primcategory(X);
		infonull(&info);
		blankfissioninfo(&R,&info);
		printf("allocation: %-3d solutionsz: %-10d fissionsz: %-10d\n",i,info.solutionsz,info.fissionsz);
		categorydestr(&R);
		while(X) trafficdestr(&X);
	}
}

void teamtest11()
{
	Traffic X;
	Category R;
	FissionInfo info;
	int i;
	int nallocs;

	nallocs=t1nodeallocsnu();
	for(i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		R=primcategory(X);
		infoconst(&info,X);

		idlefissioninfo(&R,&info);

		printf("allocation: %-3d solutionsz: %-10d fissionsz: %-10d\n",i,info.solutionsz,info.fissionsz);

		infodestr(&info);
		categorydestr(&R);
		while(X) trafficdestr(&X);
	}	
}

void teamtest12()
{
	Traffic X;
	Category R1;
	Category R2;
	FissionInfo info1;
	FissionInfo info2;
	char R1view[1000];
	char R2view[1000];
	int i;
	int nallocs;

	nallocs=t1nodeallocsnu();
	for(i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		R1=primcategory(X);
		R2=primcategory(X);
		infonull(&info1);
		infonull(&info2);

		blankfissioninfo(&R1,&info1);
		skeletonfissioninfo(&R2,&info2);

		categoryprint(R1view,R1);
		categoryprint(R2view,R2);
		printf("allocation %d:\n",i);
		printf("BlF solutionsz: %-10d fissionsz: %-10d category: %s\n",info1.solutionsz,info1.fissionsz,R1view);
		printf("SkF solutionsz: %-10d fissionsz: %-10d category: %s\n",info2.solutionsz,info2.fissionsz,R2view);
		printf("Result=%s\n\n",(info1.solutionsz==info2.solutionsz && info1.fissionsz==info2.fissionsz)?"OK":"ERROR");

		infodestr(&info1);
		infodestr(&info2);
		categorydestr(&R1);
		categorydestr(&R2);
		while(X) trafficdestr(&X);
	}	
}

void teamtest13()
{
	Traffic X;
	Traffic Sk;
	Category R1;
	Category R2;
	FissionInfo info1;
	FissionInfo info2;
	int i;
	int nallocs;

	nallocs=t1nodeallocsnu();
	for(i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		Sk=trafficskeleton(X);
		R1=primcategory(X);
		R2=primcategory(Sk);
		infoconst(&info1,X);
		infoconst(&info2,X);

		idlefissioninfo(&R1,&info1);
		skeletonfissioninfo(&R2,&info2);

		printf("allocation %d:\n",i);
		printf("IdF solutionsz: %-10d fissionsz: %-10d\n",info1.solutionsz,info1.fissionsz);
		printf("SkF solutionsz: %-10d fissionsz: %-10d\n",info2.solutionsz,info2.fissionsz);
		printf("Result=%s\n\n",(info1.solutionsz==info2.solutionsz)?"OK":"ERROR");

		infodestr(&info1);
		infodestr(&info2);
		categorydestr(&R1);
		categorydestr(&R2);
		while(Sk) trafficcut(&Sk);
		while(X) trafficdestr(&X);
	}	
}

void teamtest14()
{
	Traffic X;
	Traffic Sk;
	Category R;
	FissionInfo info;
	int i;
	int nallocs;

	nallocs=t1nodeallocsnu();
	for(i=1;i<nallocs;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		Sk=trafficskeleton(X);
		R=primcategory(Sk);
		infoconst(&info,X);

		skeletonfissioninfo(&R,&info);

		printf("allocation: %-3d solutionsz: %-10d fissionsz: %-10d\n",i,info.solutionsz,info.fissionsz);

		infodestr(&info);
		categorydestr(&R);
		while(Sk) trafficcut(&Sk);
		while(X) trafficdestr(&X);
	}	
}

/*
allocation: 1   solutionsz: 1          fissionsz: 4
allocation: 2   solutionsz: 2          fissionsz: 11
allocation: 3   solutionsz: 6          fissionsz: 37
allocation: 4   solutionsz: 24         fissionsz: 153
allocation: 5   solutionsz: 72         fissionsz: 553
allocation: 6   solutionsz: 120        fissionsz: 771
allocation: 7   solutionsz: 324        fissionsz: 3016
allocation: 8   solutionsz: 384        fissionsz: 3537
allocation: 9   solutionsz: 528        fissionsz: 3712
allocation: 10  solutionsz: 720        fissionsz: 4633
allocation: 11  solutionsz: 1728       fissionsz: 19177
allocation: 12  solutionsz: 2964       fissionsz: 22992
allocation: 13  solutionsz: 2400       fissionsz: 29521
allocation: 14  solutionsz: 3576       fissionsz: 32554
allocation: 15  solutionsz: 4224       fissionsz: 35921
allocation: 16  solutionsz: 5040       fissionsz: 32439
allocation: 17  solutionsz: 9216       fissionsz: 136481
allocation: 18  solutionsz: 10800      fissionsz: 143356
allocation: 19  solutionsz: 19776      fissionsz: 181297
allocation: 20  solutionsz: 21936      fissionsz: 182440
allocation: 21  solutionsz: 31104      fissionsz: 241801
allocation: 22  solutionsz: 32976      fissionsz: 357380
allocation: 23  solutionsz: 26688      fissionsz: 266369
allocation: 24  solutionsz: 33744      fissionsz: 360318
allocation: 25  solutionsz: 9216       fissionsz: 76025
allocation: 26  solutionsz: 57600      fissionsz: 1173241
allocation: 27  solutionsz: 115920     fissionsz: 1264316
allocation: 28  solutionsz: 88128      fissionsz: 1014553
allocation: 29  solutionsz: 136656     fissionsz: 1389336
allocation: 30  solutionsz: 230400     fissionsz: 2090785
allocation: 31  solutionsz: 186192     fissionsz: 2293636
allocation: 32  solutionsz: 276288     fissionsz: 3334481
allocation: 33  solutionsz: 254544     fissionsz: 3099816
allocation: 34  solutionsz: 162432     fissionsz: 2048425
allocation: 35  solutionsz: 94968      fissionsz: 1474228
allocation: 36  solutionsz: 246336     fissionsz: 3482261
allocation: 37  solutionsz: 157536     fissionsz: 1135075
allocation: 38  solutionsz: 211968     fissionsz: 4714737
allocation: 39  solutionsz: 693216     fissionsz: 7427776
allocation: 40  solutionsz: 681984     fissionsz: 8579585
allocation: 41  solutionsz: 936000     fissionsz: 9581296
allocation: 42  solutionsz: 1843200    fissionsz: 18599641
allocation: 43  solutionsz: 2145600    fissionsz: 34053548
allocation: 44  solutionsz: 1126656    fissionsz: 17066233
allocation: 45  solutionsz: 753696     fissionsz: 11009760
allocation: 46  solutionsz: 1234944    fissionsz: 17514785
allocation: 47  solutionsz: 1379808    fissionsz: 23088064
allocation: 48  solutionsz: 2367744    fissionsz: 40127825
allocation: 49  solutionsz: 2201568    fissionsz: 36877524
allocation: 50  solutionsz: 466560     fissionsz: 7387729
allocation: 51  solutionsz: 2233296    fissionsz: 42523762
allocation: 52  solutionsz: 1168320    fissionsz: 8558553
allocation: 53  solutionsz: 926208     fissionsz: 22605065
allocation: 54  solutionsz: 4217184    fissionsz: 46749484
allocation: 55  solutionsz: 4877568    fissionsz: 55797225
allocation: 56  solutionsz: 4106592    fissionsz: 61042400
allocation: 57  solutionsz: 9225216    fissionsz: 101375857
allocation: 58  solutionsz: 14215392   fissionsz: 282764772
allocation: 59  solutionsz: 4224384    fissionsz: 66982897
allocation: 60  solutionsz: 15188544   fissionsz: 160087322
allocation: 61  solutionsz: 14114304   fissionsz: 189106681
allocation: 62  solutionsz: 20373984   fissionsz: 460222068
allocation: 63  solutionsz: 8795520    fissionsz: 174799657
allocation: 64  solutionsz: 18642528   fissionsz: 406027930
allocation: 65  solutionsz: 7022592    fissionsz: 137290529
allocation: 66  solutionsz: 15103584   fissionsz: 354271726
allocation: 67  solutionsz: 21210624   fissionsz: 456158161
allocation: 68  solutionsz: 19497312   fissionsz: 411131732
allocation: 69  solutionsz: 5412096    fissionsz: 43308257
allocation: 70  solutionsz: 11733312   fissionsz: 86925579
allocation: 71  solutionsz: 4644864    fissionsz: 54852801
allocation: 72  solutionsz: 28432512   fissionsz: 376521868
allocation: 73  solutionsz: 25691904   fissionsz: 432899377
allocation: 74  solutionsz: 25451712   fissionsz: 489449740
allocation: 75  solutionsz: 51231744   fissionsz: 624463657
allocation: 76  solutionsz: 25427520   fissionsz: 432747964
allocation: 77  solutionsz: 101270016  fissionsz: 1119936961
allocation: 78  solutionsz: 100645632  fissionsz: -2012582792
allocation: 79  solutionsz: 106702848  fissionsz: 1288807665
allocation: 80  solutionsz: 25223616   fissionsz: 525598884
allocation: 81  solutionsz: 107083008  fissionsz: 1384461553
*/

void teamtest15()
{
	__int64 a=2282384504;
	__int64 b=444333222111;

	long b1;
	long b2;

	b1=(long)(b/1000000000);
	b2=(long)(b%1000000000);
	printf("sizeof long: %d\n",sizeof(long));
	printf("sizeof __int64: %d\n",sizeof(__int64));
	printf("a: %d\n",a);
	printf("b: %d%d\n",b1,b2);
}

/*
sizeof long: 4
sizeof __int64: 8
a: -2012582792
b: 444333222111
*/

void teamtest16()
{
	Traffic X;
	int i;
	int nallocs;

	nallocs=t1nodeallocsnu();
	for(i=2;i<63;i++)
	{
		X=t1node2node(t1nodeallocs[i]);
		printf("alloc: %-3d sz: %-2d Xsz: %-9d\n",i,t1allocsz(t1nodeallocs[i]),trafficsize(X));
		while(X) trafficdestr(&X);
	}	
}