#include "traffic.h"
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

Traffic trafficdup(Traffic X)
{
	Traffic Y=NULL;
	Traffic a;

	for(a=X;a;a=a->next)
	{
		trafficadd(&Y,a->t);
	}
	return Y;
}

int trafficcongest_wtransfer(Traffic X, Transfer x)
{
	Traffic a;

	for(a=X;a;a=a->next)
	{
		if(transferscongest(a->t,x))
			return 1;
	}
	return 0;
}

Traffic noncongestings_wtraffic(Traffic X, Traffic Y)
{
	Traffic Z;
	Traffic A;
	Transfer y;

	y=transfercreat();
	transferzero(y);
	for(A=Y;A;A=A->next)
	{
		transferunion(y,A->t);
	}

	Z=noncongestings_wtransfer(X,y);
	return Z;
}

Traffic noncongestings_wtransfer(Traffic X, Transfer x)
{
	Traffic Y=NULL;
	Traffic a;

	for(a=X;a;a=a->next)
	{
		if(!transferscongest(a->t,x))
			trafficadd(&Y,a->t);
	}
	return Y;
}

Traffic trafficconst()
{
	Traffic X;
	X=NULL;
	return X;
}

void trafficcreat(Traffic *X)
{
	Traffic X1;
	X1=*X;

	*X=(Traffic)malloc(sizeof(struct Traffic));
	if((*X)==NULL)
	{
		printf("trafficcreat: memory allocation problem\n");
	}
	(*X)->t=transfercreat();
	(*X)->next=X1;
	transferzero((*X)->t);
}

void trafficdestr(Traffic *X)
{
	Traffic X1;
	if((*X)!=NULL)
	{
		X1=*X;
		*X=(*X)->next;
		transferdestr(&(X1->t));
		free(X1);
	}
}

void trafficadd(Traffic *X, Transfer x)
{
	Traffic X1;
	X1=*X;

	*X=(Traffic)malloc(sizeof(struct Traffic));
	if((*X)==NULL)
	{
		printf("trafficadd: memory allocation problem\n");
	}
	(*X)->t=x;
	(*X)->next=X1;
}

void trafficcut(Traffic *X)
{
	Traffic X1;
	if((*X)!=NULL)
	{
		X1=*X;
		*X=(*X)->next;
		free(X1);
	}
}

void trafficprint(char *s, Traffic X)
{
	char tmp[1024];
	Traffic x;
	int first=1;

	strcpy(s,"{");
	for(x=X;x!=NULL;x=x->next)
	{
		if(!first)
			strcat(s,", ");
		transferprint(tmp,x->t);
		strcat(s,tmp);
		first=0;
	}
	strcat(s,"}");
}

//===============tests================

void traffictest1()
{
	printf("sizeof struct Traffic: %d\n",sizeof(struct Traffic));
	printf("sizeof Traffic: %d\n",sizeof(Traffic));
}

void traffictest2()
{
	Transfer a;
	Transfer b;
	Transfer c;
	Traffic X=NULL;
	char s[4096];

	a=transfercreat();
	b=transfercreat();
	c=transfercreat();

	transferzero(a);
	transferzero(b);
	transferzero(c);

	transferadd(a,0);
	transferadd(a,19);
	transferadd(a,20);
	transferadd(b,1);
	transferadd(b,22);
	transferadd(b,21);
	transferadd(c,31);
	transferadd(c,32);

	trafficadd(&X,a);
	trafficadd(&X,b);
	trafficadd(&X,c);
	trafficprint(s,X);
	printf("X=%s\n",s);

	transferadd(a,12);
	trafficprint(s,X);
	printf("X=%s\n",s);
	
	trafficcut(&X);
	trafficprint(s,X);
	printf("X=%s\n",s);

	trafficcut(&X);
	trafficprint(s,X);
	printf("X=%s\n",s);

	trafficcut(&X);
	trafficprint(s,X);
	printf("X=%s\n",s);

	trafficcut(&X);
	trafficprint(s,X);
	printf("X=%s\n",s);

	transferdestr(&a);
	transferdestr(&b);
	transferdestr(&c);
}

void traffictest3()
{
	Traffic X=NULL;
	char s[4096];

	trafficcreat(&X);
	transferadd(X->t,1);
	trafficcreat(&X);
	transferadd(X->t,2);
	transferadd(X->t,3);
	trafficcreat(&X);
	transferadd(X->t,4);
	trafficcreat(&X);
	transferadd(X->t,5);
	trafficprint(s,X);
	printf("X=%s\n",s);

	while(X)
	{
		trafficdestr(&X);
		trafficprint(s,X);
		printf("X=%s\n",s);
	}
}

void traffictest4()
{
	Traffic X=NULL;
	Traffic Y;
	char s[4096];

	trafficcreat(&X);
	transferadd(X->t,1);
	trafficcreat(&X);
	transferadd(X->t,2);
	transferadd(X->t,3);
	trafficcreat(&X);
	transferadd(X->t,4);
	trafficcreat(&X);
	transferadd(X->t,5);
	trafficprint(s,X);
	printf("X=%s\n",s);

	transferadd(X->t,55);
	transferadd(X->t,77);

	Y=trafficdup(X);
	trafficprint(s,Y);
	printf("Y=%s\n",s);
	
	while(X) trafficdestr(&X);
	while(Y) trafficcut(&Y);
}

void traffictest5()
{
	Traffic X=NULL;
	Traffic Y;
	Transfer x;
	char s[4096];

	trafficcreat(&X);
	transferadd(X->t,1);
	trafficcreat(&X);
	transferadd(X->t,2);
	transferadd(X->t,3);
	trafficcreat(&X);
	transferadd(X->t,4);
	transferadd(X->t,5);
	transferadd(X->t,6);
	trafficcreat(&X);
	transferadd(X->t,6);
	trafficcreat(&X);
	transferadd(X->t,6);
	transferadd(X->t,7);
	trafficcreat(&X);
	transferadd(X->t,7);
	transferadd(X->t,8);
	trafficprint(s,X);
	printf("X=%s\n",s);

	x=transfercreat();
	transferzero(x);
	transferadd(x,1);
	transferadd(x,6);
	transferprint(s,x);
	printf("x=%s\n",s);

	Y=noncongestings_wtransfer(X,x);
	trafficprint(s,Y);
	printf("Y=%s\n",s);
	
	transferdestr(&x);
	while(X) trafficdestr(&X);
	while(Y) trafficcut(&Y);
}

void traffictest6()
{
	Traffic X;
	int i;
	int j;
	char s[10000];

	X=trafficconst();
	for(i=5;i>0;i--)
		for(j=5;j>0;j--)
		{
			trafficcreat(&X);
			transferadd(X->t,i);
			transferadd(X->t,j+5);
			if(i<=3 && j>3)
				transferadd(X->t,11);
			if(i>3 && j<=3)
				transferadd(X->t,12);
		}
	trafficprint(s,X);
	printf("X=%s\n",s);

	while(X) trafficdestr(&X);
}

Traffic traffictest7()
{
	Traffic X;
	int i;
	int j;

	X=trafficconst();
	for(i=5;i>0;i--)
		for(j=5;j>0;j--)
		{
			trafficcreat(&X);
			transferadd(X->t,i);
			transferadd(X->t,j+5);
			if(i<=3 && j>3)
				transferadd(X->t,11);
			if(i>3 && j<=3)
				transferadd(X->t,12);
		}
	return X;
}

void traffictest8()
{
	Traffic X;
	Traffic Y;
	Traffic Z;
	char Xview[10000];
	char Yview[10000];
	char Zview[10000];

	X=trafficconst();
	Y=trafficconst();

	X=traffictest7();

	trafficcreat(&Y);
		transferadd(Y->t,1);
		transferadd(Y->t,11);
		transferadd(Y->t,9);
	trafficcreat(&Y);
		transferadd(Y->t,2);
		transferadd(Y->t,11);
		transferadd(Y->t,10);

	Z=noncongestings_wtraffic(X,Y);

	trafficprint(Xview,X);
	trafficprint(Yview,Y);
	trafficprint(Zview,Z);
	printf("Transfers of %s\n"
		"non-congesting with %s\n"
		"are %s\n",
		Xview,Yview,Zview);

	while(Z) trafficcut(&Z);
	while(X) trafficdestr(&X);
	while(Y) trafficdestr(&Y);
}
