#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>
#include "transfer.h"

int transfereq(Transfer a, Transfer b)
{
	int i;
	for(i=0;i<longnu;i++)
	{
		if(a[i]!=b[i])
			return 0;
	}
	return 1;
}

void transferunion(Transfer a, Transfer b)
{
	int i;
	for(i=0;i<longnu;i++)
		a[i]|=b[i];
}

int transferscongest(Transfer a, Transfer b)
{
	int i;
	for(i=0;i<longnu;i++)
	{
		if(a[i]&b[i])
			return 1;
	}
	return 0;
}

Transfer transfercreat()
{
	Transfer a;
	a=(Transfer)malloc(longnu*sizeof(unsigned long));
	if(a==NULL)
	{
		printf("transfercreat: memory allocation problem\n");
	}
	transferzero(a);
	return a;
}

void transferdestr(Transfer *a)
{
	free(*a);
	*a=NULL;
	return;
}

void transferzero(Transfer a)
{
	int i;
	for(i=0;i<longnu;i++)
		a[i]=0;
}

void transferadd(Transfer a, int i)
{
	if(i>=0 && i<linknu)
		a[i/longsz]|=1<<(i%longsz);
}

void transferprint(char *s, Transfer a)
{
	int i;
	int first=1;
	char tmp[256];

	strcpy(s,"{");
	for(i=0;i<linknu;i++)
	{
		if((a[i/longsz]>>(i%longsz))&1)
		{
			if(!first)
				strcat(s,",");
			sprintf(tmp,"%d",i);
			strcat(s,tmp);
			first=0;
		}
	}
	strcat(s,"}");
}

//========tests==========

void transfertest1()
{
	char aview[200];
	char bview[200];
	Transfer a;
	Transfer b;

	a=transfercreat();
	b=transfercreat();
	transferzero(a);
	transferzero(b);

	transferadd(a,0);
	transferadd(a,19);
	transferadd(a,20);
	transferadd(a,158);
	transferadd(a,159);
	transferadd(b,1);
	transferadd(b,22);
	transferadd(b,21);

	transferprint(aview,a);
	transferprint(bview,b);

	printf("Transfers %s and %s are%scongesting.\n",aview,bview,transferscongest(a,b)?" ":" not ");

	transferdestr(&a);
	transferdestr(&b);

	return;
}

void transfertest2()
{
	char aview[200];
	char bview[200];
	Transfer a;
	Transfer b;

	a=transfercreat();
	b=transfercreat();
	transferzero(a);
	transferzero(b);

	transferadd(a,0);
	transferadd(a,19);
	transferadd(a,20);
	transferadd(a,158);
	transferadd(a,159);
	transferadd(b,0);
	transferadd(b,19);
	transferadd(b,20);
	transferadd(b,158);
	//transferadd(b,159);

	transferprint(aview,a);
	transferprint(bview,b);

	printf("Transfers %s and %s are%sequal.\n",aview,bview,transfereq(a,b)?" ":" not ");

	transferdestr(&a);
	transferdestr(&b);

	return;
}

void transfertest3()
{
	char aview[200];
	char bview[200];
	char uview[200];
	Transfer a;
	Transfer b;

	a=transfercreat();
	b=transfercreat();
	transferzero(a);
	transferzero(b);

	transferadd(a,0);
	transferadd(a,19);
	transferadd(a,20);
	transferadd(a,158);
	transferadd(a,159);
	transferadd(b,1);
	transferadd(b,19);
	transferadd(b,20);

	transferprint(aview,a);
	transferprint(bview,b);
	transferunion(a,b);
	transferprint(uview,a);

	printf("The Union of %s and %s is %s.\n",aview,bview,uview);

	transferdestr(&a);
	transferdestr(&b);

	return;
}

